/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.summary;

import eu.europa.esig.dss.model.tsl.CertificatePivotStatus;
import eu.europa.esig.dss.model.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.PivotInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.model.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.parsing.ParsingUtils;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationJobSummaryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationJobSummaryBuilder.class);
    private final ReadOnlyCacheAccess readOnlyCacheAccess;
    private final TLSource[] tlSources;
    private final LOTLSource[] lotlSources;

    public ValidationJobSummaryBuilder(ReadOnlyCacheAccess readOnlyCacheAccess, TLSource[] tlSources, LOTLSource[] lotlSources) {
        this.readOnlyCacheAccess = readOnlyCacheAccess;
        this.tlSources = tlSources;
        this.lotlSources = lotlSources;
    }

    public TLValidationJobSummary build() {
        ArrayList<TLInfo> otherTLInfos = new ArrayList<TLInfo>();
        if (Utils.isArrayNotEmpty((Object[])this.tlSources)) {
            for (TLSource tlSource : this.tlSources) {
                otherTLInfos.add(this.buildTLInfo(tlSource));
            }
        }
        ArrayList<LOTLInfo> lotlList = new ArrayList<LOTLInfo>();
        if (Utils.isArrayNotEmpty((Object[])this.lotlSources)) {
            for (LOTLSource lotlSource : this.lotlSources) {
                ParsingCacheDTO lotlParsingResult = this.readOnlyCacheAccess.getParsingCacheDTO(lotlSource.getCacheKey());
                LOTLInfo lotlInfo = this.buildLOTLInfo(lotlSource);
                ArrayList<TLInfo> tlInfos = new ArrayList<TLInfo>();
                List<TLSource> currentTLSources = this.extractTLSources(lotlParsingResult);
                for (TLSource tlSource : currentTLSources) {
                    OtherTSLPointer otherTSLPointer = this.getOtherTSLPointer(lotlParsingResult.getTlOtherPointers(), tlSource.getUrl());
                    TLInfo tlInfo = this.buildTLInfo(tlSource, lotlInfo, otherTSLPointer);
                    tlInfos.add(tlInfo);
                }
                lotlInfo.setTlInfos(tlInfos);
                if (lotlSource.isPivotSupport()) {
                    LinkedList<PivotInfo> pivotInfos = new LinkedList<PivotInfo>();
                    List<CertificateToken> currentCertificates = this.getLOTLKeystoreCertificates(lotlSource);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("LOTL original keystore certs [Amount : {}] : {}", (Object)currentCertificates.size(), currentCertificates);
                    }
                    List<LOTLSource> pivotSources = this.extractPivotSources(lotlParsingResult);
                    for (LOTLSource pivotSource : pivotSources) {
                        List<CertificateToken> pivotCertificateTokens = this.getPivotCertificateTokens(pivotSource);
                        Map<CertificateToken, CertificatePivotStatus> certificateChangesMap = this.getCertificateChangesMap(pivotCertificateTokens, currentCertificates);
                        String associatedLOTLLocation = this.getAssociatedLOTLLocation(pivotSource);
                        pivotInfos.add(this.buildPivotInfo(pivotSource, certificateChangesMap, associatedLOTLLocation));
                        currentCertificates = pivotCertificateTokens;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Pivot [{}] certificate source [Amount : {}] : {}", new Object[]{pivotSource.getUrl(), currentCertificates.size(), currentCertificates});
                    }
                    lotlInfo.setPivotInfos(pivotInfos);
                } else {
                    lotlInfo.setPivotInfos(Collections.emptyList());
                }
                lotlList.add(lotlInfo);
            }
        }
        return new TLValidationJobSummary(lotlList, otherTLInfos);
    }

    private LOTLInfo buildLOTLInfo(LOTLSource lotlSource) {
        CacheKey cacheKey = lotlSource.getCacheKey();
        return new LOTLInfo((DownloadInfoRecord)this.readOnlyCacheAccess.getDownloadCacheDTO(cacheKey), (ParsingInfoRecord)this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey), (ValidationInfoRecord)this.readOnlyCacheAccess.getValidationCacheDTO(cacheKey), lotlSource.getUrl());
    }

    private TLInfo buildTLInfo(TLSource tlSource) {
        CacheKey cacheKey = tlSource.getCacheKey();
        return new TLInfo((DownloadInfoRecord)this.readOnlyCacheAccess.getDownloadCacheDTO(cacheKey), (ParsingInfoRecord)this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey), (ValidationInfoRecord)this.readOnlyCacheAccess.getValidationCacheDTO(cacheKey), tlSource.getUrl());
    }

    private TLInfo buildTLInfo(TLSource tlSource, LOTLInfo lotlInfo, OtherTSLPointer otherTSLPointer) {
        CacheKey cacheKey = tlSource.getCacheKey();
        return new TLInfo((DownloadInfoRecord)this.readOnlyCacheAccess.getDownloadCacheDTO(cacheKey), (ParsingInfoRecord)this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey), (ValidationInfoRecord)this.readOnlyCacheAccess.getValidationCacheDTO(cacheKey), tlSource.getUrl(), (TLInfo)lotlInfo, otherTSLPointer);
    }

    private PivotInfo buildPivotInfo(LOTLSource pivotSource, Map<CertificateToken, CertificatePivotStatus> certificateChangesMap, String associatedLOTLLocation) {
        CacheKey cacheKey = pivotSource.getCacheKey();
        return new PivotInfo((DownloadInfoRecord)this.readOnlyCacheAccess.getDownloadCacheDTO(cacheKey), (ParsingInfoRecord)this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey), (ValidationInfoRecord)this.readOnlyCacheAccess.getValidationCacheDTO(cacheKey), pivotSource.getUrl(), certificateChangesMap, associatedLOTLLocation);
    }

    private OtherTSLPointer getOtherTSLPointer(List<OtherTSLPointer> tlOtherPointers, String tslPointerLocation) {
        for (OtherTSLPointer otherTSLPointer : tlOtherPointers) {
            if (!Utils.areStringsEqual((String)tslPointerLocation, (String)otherTSLPointer.getTSLLocation())) continue;
            return otherTSLPointer;
        }
        return null;
    }

    private List<TLSource> extractTLSources(ParsingCacheDTO lotlParsingResult) {
        ArrayList<TLSource> result = new ArrayList<TLSource>();
        if (lotlParsingResult != null && lotlParsingResult.isResultExist()) {
            List<OtherTSLPointer> tlPointers = lotlParsingResult.getTlOtherPointers();
            for (OtherTSLPointer otherTSLPointerDTO : tlPointers) {
                TLSource tlSource = new TLSource();
                tlSource.setUrl(otherTSLPointerDTO.getTSLLocation());
                result.add(tlSource);
            }
        }
        return result;
    }

    private List<CertificateToken> getLOTLKeystoreCertificates(LOTLSource lotlSource) {
        CertificateSource certificateSource = lotlSource.getCertificateSource();
        if (certificateSource != null) {
            return certificateSource.getCertificates();
        }
        LOG.warn("Certificate source is not defined for the LOTL with URL [{}]", (Object)lotlSource.getUrl());
        return Collections.emptyList();
    }

    private List<LOTLSource> extractPivotSources(ParsingCacheDTO lotlParsingResult) {
        LinkedList<LOTLSource> result = new LinkedList<LOTLSource>();
        if (lotlParsingResult != null && lotlParsingResult.isResultExist()) {
            List<String> pivotUrls = lotlParsingResult.getPivotUrls();
            for (String pivotUrl : pivotUrls) {
                LOTLSource pivotSource = new LOTLSource();
                pivotSource.setUrl(pivotUrl);
                result.add(pivotSource);
            }
        }
        return Utils.reverseList(result);
    }

    private List<CertificateToken> getPivotCertificateTokens(LOTLSource pivotSource) {
        int lotlOtherPointersAmount;
        CacheKey cacheKey = pivotSource.getCacheKey();
        ParsingCacheDTO parsingCacheDTO = this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey);
        List<OtherTSLPointer> lotlOtherPointers = parsingCacheDTO.getLotlOtherPointers();
        int n = lotlOtherPointersAmount = Utils.isCollectionNotEmpty(lotlOtherPointers) ? lotlOtherPointers.size() : 0;
        if (lotlOtherPointersAmount == 1) {
            return lotlOtherPointers.get(0).getSdiCertificates();
        }
        LOG.debug("Pivot certificates were not extracted. Nb of OtherTSLPointers is [{}]", (Object)lotlOtherPointersAmount);
        return Collections.emptyList();
    }

    private Map<CertificateToken, CertificatePivotStatus> getCertificateChangesMap(List<CertificateToken> pivotSourceCertificates, List<CertificateToken> currentCertificates) {
        LinkedHashMap<CertificateToken, CertificatePivotStatus> certificateChangesMap = new LinkedHashMap<CertificateToken, CertificatePivotStatus>();
        List commonCertificates = pivotSourceCertificates.stream().filter(currentCertificates::contains).collect(Collectors.toList());
        for (CertificateToken certificateToken : pivotSourceCertificates) {
            if (commonCertificates.contains(certificateToken)) continue;
            certificateChangesMap.put(certificateToken, CertificatePivotStatus.ADDED);
        }
        for (CertificateToken certificateToken : commonCertificates) {
            certificateChangesMap.put(certificateToken, CertificatePivotStatus.NOT_CHANGED);
        }
        for (CertificateToken certificateToken : currentCertificates) {
            if (commonCertificates.contains(certificateToken)) continue;
            certificateChangesMap.put(certificateToken, CertificatePivotStatus.REMOVED);
        }
        return certificateChangesMap;
    }

    private String getAssociatedLOTLLocation(LOTLSource pivotSource) {
        CacheKey cacheKey = pivotSource.getCacheKey();
        ParsingCacheDTO parsingCacheDTO = this.readOnlyCacheAccess.getParsingCacheDTO(cacheKey);
        OtherTSLPointer xmllotlPointer = ParsingUtils.getXMLLOTLPointer(parsingCacheDTO);
        if (xmllotlPointer != null) {
            return xmllotlPointer.getTSLLocation();
        }
        return null;
    }
}

