/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import eu.europa.esig.dss.tsl.source.TLSource;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunnableAnalysis
extends AbstractAnalysis
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRunnableAnalysis.class);
    private static final String LOG_ERROR_PERFORM_ANALYSIS = "Error performing analysis.";
    private final CountDownLatch latch;

    protected AbstractRunnableAnalysis(TLSource source, CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader, CountDownLatch latch) {
        super(source, cacheAccess, dssFileLoader);
        this.latch = latch;
    }

    protected void doAnalyze() {
        DSSDocument document = this.download(this.getSource().getUrl());
        if (document != null) {
            this.parsing(document);
            this.validation(document, this.getCurrentCertificateSource());
        }
    }

    protected CertificateSource getCurrentCertificateSource() {
        return this.getSource().getCertificateSource();
    }

    @Override
    public void run() {
        try {
            this.doAnalyze();
        }
        catch (Throwable exception) {
            LOG.warn(LOG_ERROR_PERFORM_ANALYSIS, exception);
        }
        finally {
            this.latch.countDown();
        }
    }
}

