/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function;

import eu.europa.esig.dss.tsl.function.TrustServicePredicate;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.TrustServiceStatus;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceType;
import java.util.Collection;

public class GrantedTrustService
implements TrustServicePredicate {
    @Override
    public boolean test(TSPServiceType trustService) {
        if (trustService != null) {
            TSPServiceInformationType serviceInformation = trustService.getServiceInformation();
            if (TrustServiceStatus.isAcceptableStatusAfterEIDAS((String)serviceInformation.getServiceStatus()) || TrustServiceStatus.isAcceptableStatusBeforeEIDAS((String)serviceInformation.getServiceStatus())) {
                return true;
            }
            ServiceHistoryType serviceHistory = trustService.getServiceHistory();
            if (serviceHistory != null && Utils.isCollectionNotEmpty((Collection)serviceHistory.getServiceHistoryInstance())) {
                for (ServiceHistoryInstanceType serviceHistoryInstance : serviceHistory.getServiceHistoryInstance()) {
                    if (!TrustServiceStatus.isAcceptableStatusAfterEIDAS((String)serviceHistoryInstance.getServiceStatus()) && !TrustServiceStatus.isAcceptableStatusBeforeEIDAS((String)serviceHistoryInstance.getServiceStatus())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

