/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.state;

import eu.europa.esig.dss.tsl.cache.state.CacheContext;
import eu.europa.esig.dss.tsl.cache.state.CacheState;
import eu.europa.esig.dss.tsl.cache.state.CacheStateEnum;
import eu.europa.esig.dss.tsl.cache.state.CachedExceptionWrapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentCacheContext
implements CacheContext {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentCacheContext.class);
    private CacheState state;
    private Date lastStateTransitionTime;
    private Date lastSuccessSynchronizationTime;
    private CachedExceptionWrapper exception;

    public CurrentCacheContext() {
        this.state(CacheStateEnum.REFRESH_NEEDED);
    }

    @Override
    public CacheStateEnum getCurrentState() {
        return (CacheStateEnum)this.state;
    }

    @Override
    public Date getLastStateTransitionTime() {
        return this.lastStateTransitionTime;
    }

    @Override
    public Date getLastSuccessSynchronizationTime() {
        return this.lastSuccessSynchronizationTime;
    }

    @Override
    public void state(CacheState newState) {
        LOG.trace("State transition from '{}' to '{}'", (Object)this.state, (Object)newState);
        if (this.state == newState) {
            LOG.trace("The newer state is the same. The CurrentCacheContext is not updated.");
        } else {
            this.state = newState;
            this.lastStateTransitionTime = new Date();
            this.exception = null;
        }
    }

    @Override
    public void syncUpdateDate() {
        this.lastSuccessSynchronizationTime = new Date();
    }

    @Override
    public void error(CachedExceptionWrapper cachedException) {
        LOG.trace("State transition from '{}' to '{}'", (Object)this.state, (Object)CacheStateEnum.ERROR);
        this.state = CacheStateEnum.ERROR;
        this.exception = cachedException;
    }

    @Override
    public void errorUpdateDate(CachedExceptionWrapper updatedException) {
        LOG.trace("Exception last occurrence updated '{}'", (Object)updatedException.getDate());
        this.exception.setLastOccurrenceDate(updatedException.getDate());
    }

    @Override
    public void desync() {
        this.state.desync(this);
    }

    @Override
    public void sync() {
        this.state.sync(this);
        this.syncUpdateDate();
    }

    @Override
    public void refreshNeeded() {
        this.state.refreshNeeded(this);
    }

    @Override
    public void toBeDeleted() {
        this.state.toBeDeleted(this);
    }

    @Override
    public boolean isRefreshNeeded() {
        return CacheStateEnum.REFRESH_NEEDED == this.state;
    }

    @Override
    public boolean isError() {
        return CacheStateEnum.ERROR == this.state;
    }

    @Override
    public CachedExceptionWrapper getException() {
        return this.exception;
    }

    @Override
    public boolean isToBeDeleted() {
        return CacheStateEnum.TO_BE_DELETED == this.state;
    }

    @Override
    public boolean isDesync() {
        return CacheStateEnum.DESYNCHRONIZED == this.state;
    }
}

