/*
 * Decompiled with CFR 0.152.
 */
package com.anf.trust.certs;

import com.anf.trust.certs.ANFTrustManager;
import com.anf.trust.certs.CertResourceHandler;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrustFactory {
    private final Logger log = LogManager.getLogger(TrustFactory.class);
    private ANFTrustManager cached;
    private boolean trustAll = false;

    public TrustFactory() {
    }

    public TrustFactory(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void configureTLS() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        CertResourceHandler.getHandler().setUseTrustedURL(true);
        SSLContext sslContext = this.getSSLContext(new X509Certificate[0]);
        SSLContext.setDefault(sslContext);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    public SSLContext getSSLContext(X509Certificate ... others) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.getSSLContext(false, others);
    }

    public SSLContext getSSLContext(boolean reload, X509Certificate ... others) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{this.getTrustManager(reload, others)}, null);
        return sslContext;
    }

    public ANFTrustManager getTrustManager(X509Certificate ... others) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.getTrustManager(false, others);
    }

    public ANFTrustManager getTrustManager(boolean reload, X509Certificate ... others) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (this.cached != null && !reload) {
            return this.cached;
        }
        this.cached = new ANFTrustManager(this.trustAll, this.getDefaultTrustManager(), this.getANFTrustManager(others));
        return this.cached;
    }

    public X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
            X509TrustManager ctm;
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = ctm = (X509TrustManager)tm;
            break;
        }
        return defaultTm;
    }

    public X509TrustManager getANFTrustManager(X509Certificate ... others) {
        X509TrustManager anfTm = null;
        try {
            KeyStore anfTrustStore = CertResourceHandler.getHandler().getTrusStore(others);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(anfTrustStore);
            for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
                X509TrustManager ctm;
                if (!(tm instanceof X509TrustManager)) continue;
                anfTm = ctm = (X509TrustManager)tm;
                break;
            }
        }
        catch (Exception e1) {
            this.log.error("no se pudo cargar el trust manager de anf", (Throwable)e1);
        }
        return anfTm;
    }
}

