/*
 * Decompiled with CFR 0.152.
 */
package com.anf.trust.certs;

import com.anf.cert.utils.CertUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public final class CertResourceHandler {
    private static final Logger log = LogManager.getLogger(CertResourceHandler.class);
    private static final String storeCerts = "/" + CertResourceHandler.class.getPackage().getName().replace(".", "/") + "/";
    private static final String resFileName = storeCerts + "certs.properties";
    private static CertResourceHandler handler = new CertResourceHandler();
    private Properties props = new Properties();
    private Map<String, X509Certificate> certs = new TreeMap<String, X509Certificate>();
    private List<X509Certificate> trustedCerts = null;
    private boolean useTrustedURL = true;
    private String trustedUrl = "https://anf-recursos.s3.eu-west-1.amazonaws.com/trusted-certs/trusted.zip";

    private CertResourceHandler() {
        try {
            this.props.load(CertResourceHandler.class.getResourceAsStream(resFileName));
            this.props.getProperty("100369942780184400");
            Set<Map.Entry<Object, Object>> set = this.props.entrySet();
            for (Map.Entry<Object, Object> e : set) {
                try {
                    X509Certificate cert = CertResourceHandler.readFromJar(e.getValue().toString());
                    this.certs.put(e.getKey().toString(), cert);
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
        }
        catch (IOException e) {
            log.error("error cargando los certificados", (Throwable)e);
        }
    }

    public static CertResourceHandler getHandler() {
        return handler;
    }

    public void setUseTrustedURL(boolean useTrustedURL) {
        this.useTrustedURL = useTrustedURL;
    }

    public boolean isUseTrustedURL() {
        return this.useTrustedURL;
    }

    public String getTrustedUrl() {
        return this.trustedUrl;
    }

    public void setTrustedUrl(String trustedUrl) {
        this.trustedUrl = trustedUrl;
    }

    public void forEachAlias(Consumer<String> action) {
        for (String alias : this.certs.keySet()) {
            action.accept(alias);
        }
    }

    public void forEachCert(Consumer<X509Certificate> action) {
        for (X509Certificate cert : this.certs.values()) {
            action.accept(cert);
        }
    }

    public static X509Certificate readFromJar(String certResName) throws Exception {
        try {
            String pathName = storeCerts.concat(certResName);
            return CertResourceHandler.readFromJarPath(pathName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception("error de lectura del cert como recurso:" + certResName);
        }
    }

    public static X509Certificate readFromJarPath(String certResPath) throws Exception {
        try {
            log.debug("read cert from resource in jar: " + certResPath);
            InputStream resourceAsStream = CertResourceHandler.class.getResourceAsStream(certResPath);
            if (resourceAsStream != null) {
                return CertUtils.getCert(resourceAsStream);
            }
            log.info("cert resource not found: " + certResPath);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception("error de lectura del cert como recurso:" + certResPath);
        }
        return null;
    }

    public X509Certificate findIssuerCert(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        if (CertUtils.isSelfSigned(cert)) {
            return cert;
        }
        log.debug("findIssuerCert: " + cert.getIssuerX500Principal().getName());
        Set<Map.Entry<String, X509Certificate>> set = this.certs.entrySet();
        if (!cert.getClass().getSimpleName().equals("X509CertImpl")) {
            cert = this.convertCertToX509CertImpl(cert);
        }
        return this.findIssuerInSet(cert, set);
    }

    private X509Certificate convertCertToX509CertImpl(X509Certificate cert) {
        try {
            cert = CertUtils.getCert(new ByteArrayInputStream(cert.getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return cert;
    }

    private X509Certificate findIssuerInSet(X509Certificate cert, Set<Map.Entry<String, X509Certificate>> set) {
        for (Map.Entry<String, X509Certificate> e : set) {
            try {
                log.debug("isIssuer {} of {} ?", (Object)e.getKey(), (Object)cert.getSerialNumber());
                if (!CertUtils.isIssuer(cert, e.getValue())) continue;
                log.debug("{} is issuer of {} ({})", (Object)e.getValue().getSubjectX500Principal(), (Object)cert.getSerialNumber(), (Object)cert.getSubjectX500Principal());
                return e.getValue();
            }
            catch (Throwable e1) {
                log.error((Object)e1);
            }
        }
        return null;
    }

    public Set<String> getCertAliases() {
        return this.certs.keySet();
    }

    public X509Certificate getCertificate(String alias) {
        return this.certs.get(alias);
    }

    public String getResourceName(String alias) {
        return this.props.getProperty(alias);
    }

    public KeyStore getTrusStore(X509Certificate ... others) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return this.getTrusStore("1234".toCharArray(), "JKS", null, others);
    }

    public KeyStore getTrusStore(char[] pin, String type, OutputStream storeStream, X509Certificate ... others) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore trustStore = KeyStore.getInstance(type);
        trustStore.load(null, pin);
        Set<Map.Entry<String, X509Certificate>> set = this.certs.entrySet();
        for (Map.Entry<String, X509Certificate> e : set) {
            try {
                trustStore.setCertificateEntry(e.getKey().replace(" ", "_"), e.getValue());
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        if (others != null && others.length > 0) {
            for (int i = 0; i < others.length; ++i) {
                try {
                    if (others[i] == null) continue;
                    X500Name x500name = new JcaX509CertificateHolder(others[i]).getSubject();
                    String alias = UUID.randomUUID().toString();
                    RDN[] fields = x500name.getRDNs(BCStyle.CN);
                    if (fields != null && fields.length > 0) {
                        RDN cn = fields[0];
                        String cnStr = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
                        alias = cnStr = cnStr.replace(" ", "_");
                    }
                    trustStore.setCertificateEntry(alias, others[i]);
                    continue;
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
        }
        this.addCertificatesFromTrustServer(trustStore);
        if (storeStream != null) {
            trustStore.store(storeStream, pin);
            storeStream.close();
        }
        return trustStore;
    }

    private synchronized void addCertificatesFromTrustServer(KeyStore trustStore) {
        if (this.trustedCerts != null && !this.trustedCerts.isEmpty()) {
            try {
                log.info("cargando certificados de confianza ya cargados en memoria");
                for (X509Certificate cert : this.trustedCerts) {
                    log.debug("trust store cert entry: serial: {}, subject: {}", (Object)cert.getSerialNumber(), (Object)cert.getSubjectX500Principal());
                    trustStore.setCertificateEntry(cert.getSerialNumber().toString(), cert);
                }
            }
            catch (Throwable e) {
                log.error("error cargando los certificados de confianza desde memoria", e);
            }
        } else if (this.useTrustedURL && this.trustedUrl != null) {
            try {
                log.info("cargando certificados de confianza desde s3");
                this.trustedCerts = new ArrayList<X509Certificate>();
                URL url = new URL(this.trustedUrl);
                InputStream in = url.openStream();
                try (ZipInputStream zipInput = new ZipInputStream(in);){
                    ZipEntry entry = null;
                    while ((entry = zipInput.getNextEntry()) != null) {
                        X509Certificate cert = CertUtils.getCert(zipInput);
                        log.debug("trust store cert entry: serial: {}, subject: {}", (Object)cert.getSerialNumber(), (Object)cert.getSubjectX500Principal());
                        trustStore.setCertificateEntry(entry.getName(), cert);
                        this.trustedCerts.add(cert);
                    }
                }
                log.info("cargados {} certificados desde s3", (Object)this.trustedCerts.size());
            }
            catch (Throwable e) {
                log.error("error cargando los certificados de confianza de s3", e);
            }
        }
    }

    public boolean isRootCert(X509Certificate cur) {
        if (cur != null) {
            for (X509Certificate cert : this.certs.values()) {
                if (!cert.getSerialNumber().toString().equals(cur.getSerialNumber().toString()) && !cert.getSubjectX500Principal().equals(cur.getSubjectX500Principal())) continue;
                return true;
            }
        }
        return false;
    }
}

