/*
 * Decompiled with CFR 0.152.
 */
package com.anf.trust.certs;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class ANFTrustManager
implements X509TrustManager {
    private final Logger log = LogManager.getLogger(ANFTrustManager.class);
    private boolean trustAll;
    private Map<String, X509Certificate> certs = new TreeMap<String, X509Certificate>();
    private KeyStore trustStore;
    private TrustManagerFactory trustManagerFactory;
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

    public ANFTrustManager(boolean trustAll, X509TrustManager ... others) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.trustAll = trustAll;
        if (trustAll) {
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(null, null);
            this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        if (others != null && others.length > 0) {
            for (X509TrustManager trustManager : others) {
                this.trustManagers.add(trustManager);
            }
        }
        for (X509TrustManager trustManager : this.trustManagers) {
            this.addCerts(trustManager.getAcceptedIssuers());
        }
        this.log.info("total de certificados de confianza guardados: {}", (Object)this.certs.size());
    }

    private void addCerts(X509Certificate[] issuers) {
        try {
            int added = 0;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            for (X509Certificate cert : issuers) {
                if (!this.addTrustedCert(digest, cert)) continue;
                ++added;
            }
            if (added > 0 && this.trustAll) {
                this.trustManagerFactory.init(this.trustStore);
            }
            this.log.info("{} certificados nuevos guardados en el almacen de confianza", (Object)added);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            this.log.catching((Throwable)e);
        }
    }

    private boolean addTrustedCert(MessageDigest digest, X509Certificate cert) {
        try {
            byte[] hash = digest.digest(cert.getEncoded());
            String hexHash = Hex.toHexString((byte[])hash);
            if (this.certs.put(hexHash, cert) == null) {
                if (this.trustAll) {
                    this.trustStore.setCertificateEntry(hexHash, cert);
                }
                return true;
            }
        }
        catch (KeyStoreException | CertificateEncodingException e) {
            this.log.warn("no se pudo almacenar el certificado de confianza {} {} {}", (Object)cert.getSerialNumber(), (Object)cert.getSubjectX500Principal(), (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.certs.values().toArray(new X509Certificate[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustAll) {
            TrustManager[] defaultTrustManagers;
            this.addCerts(chain);
            this.printChain(chain);
            for (TrustManager trustManager : defaultTrustManagers = this.trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager certTrustManager = (X509TrustManager)trustManager;
                certTrustManager.checkServerTrusted(chain, authType);
                return;
            }
        }
        if (!this.trustManagers.isEmpty()) {
            this.trustManagers.get(0).checkServerTrusted(chain, authType);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustAll) {
            this.addCerts(chain);
            this.printChain(chain);
        }
        CertificateException lastError = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    private void printChain(X509Certificate[] chain) {
        StringBuilder sb = new StringBuilder();
        if (chain != null) {
            for (X509Certificate cert : chain) {
                try {
                    sb.append(cert.getSerialNumber().toString(16) + " " + cert.getSubjectX500Principal()).append("\n").append(Hex.toHexString((byte[])cert.getEncoded())).append("\n");
                }
                catch (CertificateEncodingException e) {
                    this.log.catching((Throwable)e);
                }
            }
        } else {
            sb.append("la cadena de certificados esta vacia");
        }
        this.log.debug(sb.toString());
    }
}

