/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.utils;

import com.anf.cert.utils.CertUtils;
import com.anf.cert.utils.NotInStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoreUtils {
    static KeyStore ksjks;
    private static final Logger log;

    StoreUtils() {
        try {
            this.iniciarKeystore();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    private void iniciarKeystore() throws KeyStoreException, NoSuchProviderException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        ksjks = KeyStore.getInstance("UBER", "BC");
        String password = "M9kgdLQs";
        FileInputStream fileInputStream = new FileInputStream("C:/ca.ks");
        ksjks.load(fileInputStream, password.toCharArray());
    }

    public X509Certificate buscarIssuer(X509Certificate certToAnalice) throws KeyStoreException, Exception {
        return CertUtils.getIssuerCertificate(certToAnalice);
    }

    public ArrayList<X509Certificate> getRoots(X509Certificate certToAnalice) throws KeyStoreException, CertificateException, NotInStoreException, Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(certToAnalice);
        if (certToAnalice.getSubjectX500Principal().equals(certToAnalice.getIssuerX500Principal())) {
            return certList;
        }
        Enumeration<String> aliases = ksjks.aliases();
        while (aliases.hasMoreElements()) {
            boolean[] suerUniqueID;
            boolean[] subjectUniqueID;
            X509Certificate certificate = (X509Certificate)ksjks.getCertificate(aliases.nextElement());
            X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
            X500Principal suerX500Principal = certToAnalice.getIssuerX500Principal();
            if (!suerX500Principal.equals(subjectX500Principal) || !Arrays.equals(subjectUniqueID = certificate.getSubjectUniqueID(), suerUniqueID = certToAnalice.getIssuerUniqueID())) continue;
            certList.add(certificate);
            return this.getRoots(certificate, certList);
        }
        throw new NotInStoreException("cert not in store");
    }

    private ArrayList<X509Certificate> getRoots(X509Certificate certToAnalice, ArrayList<X509Certificate> certList) throws KeyStoreException, NotInStoreException {
        if (certToAnalice.getSubjectX500Principal().equals(certToAnalice.getIssuerX500Principal())) {
            return certList;
        }
        Enumeration<String> aliases = ksjks.aliases();
        while (aliases.hasMoreElements()) {
            boolean[] suerUniqueID;
            boolean[] subjectUniqueID;
            X509Certificate certificate = (X509Certificate)ksjks.getCertificate(aliases.nextElement());
            X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
            X500Principal suerX500Principal = certToAnalice.getIssuerX500Principal();
            if (!suerX500Principal.equals(subjectX500Principal) || !Arrays.equals(subjectUniqueID = certificate.getSubjectUniqueID(), suerUniqueID = certToAnalice.getIssuerUniqueID())) continue;
            certList.add(certificate);
            return this.getRoots(certificate, certList);
        }
        throw new NotInStoreException("not in store");
    }

    private X509Certificate[] getCertificateChain(File f) throws FileNotFoundException, CertificateException, NoSuchProviderException {
        FileInputStream fis = new FileInputStream(f);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        Collection<? extends Certificate> c = cf.generateCertificates(fis);
        X509Certificate[] cert509 = new X509Certificate[c.size()];
        return c.toArray(cert509);
    }

    public static void main(String[] args) throws KeyStoreException, NoSuchProviderException, FileNotFoundException, IOException, IOException, NoSuchAlgorithmException, NoSuchAlgorithmException, CertificateException, Exception {
        StoreUtils storeUtils = new StoreUtils();
        X509Certificate[] certificateChain = storeUtils.getCertificateChain(new File("C:/Documents and Settings/Rober/Mis documentos/NetBeansProjects/leercerts/MARIA_TERESA_YEREGUI_SANTAMARIA_ANF_Clase_SubCA.pem"));
        X509Certificate buscarIssuer = storeUtils.buscarIssuer(certificateChain[0]);
        X500Principal suerX500Principal = buscarIssuer.getIssuerX500Principal();
        log.error("yeyyea");
        ArrayList<X509Certificate> roots = storeUtils.getRoots(certificateChain[0]);
        roots.size();
    }

    static {
        log = LogManager.getLogger(StoreUtils.class);
    }
}

