/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.utils;

import com.anf.cert.utils.KeyUsageUtils;
import java.security.cert.X509Certificate;

public enum CertType {
    unknokn,
    signature,
    auth,
    cipher,
    seal,
    ssl,
    sede;


    public static CertType getCertType(X509Certificate cert) {
        CertType[] values = CertType.values();
        for (int i = 0; i < values.length; ++i) {
            CertType local = values[i];
            if (local == unknokn || !CertType.certHasCertType(cert, local)) continue;
            return local;
        }
        return unknokn;
    }

    public static boolean certHasAuthenticateType(X509Certificate cert) {
        return cert.getKeyUsage() != null && KeyUsageUtils.isAuthentication(cert.getKeyUsage());
    }

    public static boolean certHasSignType(X509Certificate cert) {
        return cert.getKeyUsage() != null && KeyUsageUtils.isDigitalSignature(cert.getKeyUsage());
    }

    public static boolean certHasCipherType(X509Certificate cert) {
        return cert.getKeyUsage() != null && KeyUsageUtils.isCipher(cert.getKeyUsage());
    }

    public static boolean certHasCertType(X509Certificate cert, CertType type) {
        boolean has = false;
        if (type == unknokn) {
            has = true;
        } else if (type == signature) {
            if (CertType.certHasSignType(cert)) {
                has = true;
            }
        } else if (type == auth) {
            if (CertType.certHasAuthenticateType(cert)) {
                has = true;
            }
        } else if (type == cipher) {
            if (CertType.certHasCipherType(cert)) {
                has = true;
            }
        } else if (type == ssl) {
            if (CertType.certHasSignType(cert)) {
                has = true;
            }
        } else if (type == sede && CertType.certHasSignType(cert)) {
            has = true;
        }
        return has;
    }
}

