/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.utils;

import com.anf.cert.utils.AsciiUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class CertExporter {
    private static final Logger log = LogManager.getLogger(CertExporter.class);
    private int sequence = 0;
    private int tagObj = 0;
    private int DERBitStringi = 0;
    private int DERUniversalStringi = 0;
    private int DERVisibleStringi = 0;
    private int DERUTCTimei = 0;
    private int DERBMPStringi = 0;
    private int DEREnumeratedi = 0;
    private int ASN1Nulli = 0;
    private int DERExternali = 0;
    private int DERGeneralStringi = 0;
    private int DERGeneralizedTimei = 0;
    private int DERIA5Stringi = 0;
    private int DERNumericStringi = 0;
    private int DERPrintableStringi = 0;
    private int DERT61Stringi = 0;
    private int DERUTF8Stringi = 0;
    private int DERStringi = 0;
    private int DERIntegeri = 0;
    private int DERBooleani = 0;
    private int ASN1ObjectIdentifieri = 0;
    private int ASN1Seti = 0;
    private int DEROctetStringi = 0;
    private int DERApplicationSpecifici = 0;
    private int ASN1Objecti = 0;
    private int DERUnknownTag = 0;
    protected X509Certificate[] certificateChain;

    public CertExporter() {
    }

    public CertExporter(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public StringBuilder exportToXML() throws IOException, NoSuchAlgorithmException, ParseException, IllegalArgumentException {
        StringBuilder xmlData = new StringBuilder();
        xmlData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.exportCertificateChainToXML(this.certificateChain, xmlData);
        return xmlData;
    }

    public void exportCertificateChainToXML(X509Certificate[] certChain, StringBuilder xmlData) throws IOException, NoSuchAlgorithmException, ParseException {
        xmlData.append("<CERTIFICATES>");
        for (int i = 0; i < certChain.length; ++i) {
            X509Certificate mainCert = certChain[i];
            xmlData.append("<CERTIFICATE").append(i + 1).append(">");
            xmlData.append("<TBSCertificate>");
            this.writeTBSCertificate(mainCert, xmlData);
            xmlData.append("</TBSCertificate>");
            xmlData.append("<signatureAlgorithm>");
            xmlData.append(mainCert.getSigAlgName());
            xmlData.append("</signatureAlgorithm>");
            xmlData.append("<signatureValue>");
            CertExporter.writeEncoded(mainCert.getSignature(), xmlData);
            xmlData.append("</signatureValue>");
            xmlData.append("</CERTIFICATE").append(i + 1).append(">");
        }
        xmlData.append("</CERTIFICATES>");
    }

    private void writeTBSCertificate(X509Certificate mainCert, StringBuilder xmlData) throws NoSuchAlgorithmException, IOException, ParseException {
        int version = mainCert.getVersion();
        xmlData.append("<version>").append("V").append(version).append("</version>");
        BigInteger serialNumber = mainCert.getSerialNumber();
        xmlData.append("<serialNumber>").append(serialNumber.toString(10)).append("</serialNumber>");
        xmlData.append("<signature>");
        this.writeAlgorithmIdentifier(mainCert, xmlData);
        xmlData.append("</signature>");
        xmlData.append("<issuer>");
        this.writeIssuer(mainCert.getIssuerX500Principal(), xmlData);
        xmlData.append("</issuer>");
        xmlData.append("<validity>");
        CertExporter.writeValidty(mainCert, xmlData);
        xmlData.append("</validity>");
        xmlData.append("<subject>");
        this.writePrincipal(mainCert.getSubjectX500Principal(), xmlData);
        xmlData.append("</subject>");
        xmlData.append("<subjectPublicKeyInfo>");
        CertExporter.writePublicKeyInfo(mainCert.getPublicKey(), xmlData);
        xmlData.append("</subjectPublicKeyInfo>");
        this.writeIssuerUniqueID(mainCert, xmlData);
        CertExporter.writeSubjectUniqueID(mainCert, xmlData);
        xmlData.append("<extensions>");
        this.writeExtensions(mainCert, xmlData);
        xmlData.append("</extensions>");
    }

    private void writeIssuerUniqueID(X509Certificate mainCert, StringBuilder xmlData) {
        boolean[] suerUniqueID = mainCert.getIssuerUniqueID();
        if (suerUniqueID != null) {
            xmlData.append("<issuerUniqueID>");
            StringBuilder StringBuilder2 = new StringBuilder();
            for (int i = 0; i < suerUniqueID.length; ++i) {
                StringBuilder2.append(suerUniqueID[i]);
            }
            xmlData.append("<BIT_STRING>");
            xmlData.append(StringEscapeUtils.escapeXml11((String)StringBuilder2.toString()));
            xmlData.append("</BIT_STRING>");
            xmlData.append("</issuerUniqueID>");
        }
    }

    private static void writeSubjectUniqueID(X509Certificate mainCert, StringBuilder xmlData) {
        boolean[] suerUniqueID = mainCert.getSubjectUniqueID();
        if (suerUniqueID != null) {
            xmlData.append("<subjectUniqueID>");
            StringBuilder StringBuilder2 = new StringBuilder();
            for (int i = 0; i < suerUniqueID.length; ++i) {
                StringBuilder2.append(suerUniqueID[i]);
            }
            xmlData.append("<BIT_STRING>");
            xmlData.append((CharSequence)StringBuilder2);
            xmlData.append("</BIT_STRING>");
            xmlData.append("</subjectUniqueID>");
        }
    }

    protected static void doFingerprint(byte[] certificateBytes, String algorithm) {
        try {
            System.out.print("  " + algorithm + ": ");
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(certificateBytes);
            byte[] digest = md.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b;
                String hex;
                if (i != 0) {
                    System.out.print(":");
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    System.out.print("0");
                }
                System.out.print(hex);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            log.error((Object)ex);
        }
    }

    private void writeAlgorithmIdentifier(X509Certificate mainCert, StringBuilder xmlData) throws NoSuchAlgorithmException, IOException {
        String sigAlgName = StringEscapeUtils.escapeXml11((String)mainCert.getSigAlgName());
        xmlData.append("<algorithm>").append(sigAlgName).append("</algorithm>");
        byte[] sigAlgParams = mainCert.getSigAlgParams();
        if (sigAlgParams != null) {
            String string = new String(Base64.encode((byte[])sigAlgParams), "utf-8");
            xmlData.append("<parameters>").append(StringEscapeUtils.escapeXml11((String)string)).append("</parameters>");
        }
    }

    private static void writeValidty(X509Certificate mainCert, StringBuilder xmlData) throws ParseException {
        TimeZone tzUTC = TimeZone.getTimeZone("Etc/UTC");
        String sNotBefore = CertExporter.getStringDate("yyyy/MM/dd HH:mm:ss", mainCert.getNotAfter(), tzUTC);
        xmlData.append("<notBefore>").append(sNotBefore).append("</notBefore>");
        String sNotAfter = CertExporter.getStringDate("yyyy/MM/dd HH:mm:ss", mainCert.getNotBefore(), tzUTC);
        xmlData.append("<notAfter>").append(sNotAfter).append("</notAfter>");
    }

    public static String getStringDate(String pattern, Date date, TimeZone timeZone) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setTimeZone(timeZone);
        return formatter.format(date);
    }

    private static void writeEncoded(byte[] bytes, StringBuilder data) throws IOException {
        char[] buf = new char[64];
        bytes = Base64.encode((byte[])bytes);
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            data.append("<Binary_Row_InBase64>");
            data.append(new String(buf, 0, index));
            data.append("</Binary_Row_InBase64>");
        }
    }

    private void writePrincipal(X500Principal principal, StringBuilder xmlData) throws IOException {
        try (ASN1InputStream x500Input = new ASN1InputStream((InputStream)new ByteArrayInputStream(principal.getEncoded()));){
            RDN[] rdNs;
            ASN1Primitive derObj = x500Input.readObject();
            X500Name name = X500Name.getInstance((Object)derObj);
            for (RDN rdn : rdNs = name.getRDNs()) {
                AttributeTypeAndValue[] typesAndValues;
                for (AttributeTypeAndValue typeValue : typesAndValues = rdn.getTypesAndValues()) {
                    ASN1ObjectIdentifier oid = typeValue.getType();
                    ASN1Encodable value = typeValue.getValue();
                    xmlData.append("<AttributeTypeAndValue.").append(oid.getId()).append(">");
                    xmlData.append("<AttributeType>").append(oid.getId()).append("</AttributeType>");
                    String escapeXml = StringEscapeUtils.escapeXml11((String)value.toString());
                    xmlData.append("<AttributeValue>").append(escapeXml).append("</AttributeValue>");
                    xmlData.append("</AttributeTypeAndValue.").append(oid.getId()).append(">");
                }
            }
        }
    }

    private void writeIssuer(X500Principal principal, StringBuilder xmlData) throws IOException {
        try (ASN1InputStream x500Input = new ASN1InputStream((InputStream)new ByteArrayInputStream(principal.getEncoded()));){
            RDN[] rdNs;
            ASN1Primitive derObj = x500Input.readObject();
            X500Name name = X500Name.getInstance((Object)derObj);
            for (RDN rdn : rdNs = name.getRDNs()) {
                AttributeTypeAndValue[] typesAndValues;
                for (AttributeTypeAndValue typeValue : typesAndValues = rdn.getTypesAndValues()) {
                    ASN1ObjectIdentifier oid = typeValue.getType();
                    ASN1Encodable value = typeValue.getValue();
                    xmlData.append("<issuer.AttributeTypeAndValue.").append(oid.getId()).append(">");
                    xmlData.append("<AttributeType>").append(oid.getId()).append("</AttributeType>");
                    String escapeXml = StringEscapeUtils.escapeXml11((String)value.toString());
                    xmlData.append("<AttributeValue>").append(escapeXml).append("</AttributeValue>");
                    xmlData.append("</issuer.AttributeTypeAndValue.").append(oid.getId()).append(">");
                }
            }
        }
    }

    private static void writePublicKeyInfo(PublicKey key, StringBuilder xmlData) throws IOException {
        String algorithm = key.getAlgorithm();
        xmlData.append("<algorithm>").append(algorithm).append("</algorithm>");
        xmlData.append("<subjectPublicKey>");
        String keySize = "--";
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)key;
            keySize = String.valueOf(rsaPub.getModulus().bitLength());
            xmlData.append("<keySize>").append(keySize).append("</keySize>");
            BigInteger modulus = rsaPub.getModulus();
            BigInteger publicExponent = rsaPub.getPublicExponent();
            xmlData.append("<modulus>").append(modulus).append("</modulus>");
            xmlData.append("<publicExponent>").append(publicExponent).append("</publicExponent>");
        }
        xmlData.append("</subjectPublicKey>");
    }

    private void writeExtensions(X509Certificate mainCert, StringBuilder xmlData) throws IOException {
        Set<String> criticalExts = mainCert.getCriticalExtensionOIDs();
        if (criticalExts != null) {
            for (String extOID : criticalExts) {
                byte[] extValue = mainCert.getExtensionValue(extOID);
                this.writeExtension(true, extOID, extValue, xmlData);
            }
            Set<String> nonCriticalExts = mainCert.getNonCriticalExtensionOIDs();
            for (String extOID : nonCriticalExts) {
                byte[] extValue = mainCert.getExtensionValue(extOID);
                this.writeExtension(false, extOID, extValue, xmlData);
            }
        }
    }

    public void exportToXmlForensic(byte[] extValue, StringBuilder xmlData) throws IOException {
        ASN1InputStream extOSInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(extValue));
        ASN1Primitive derObj = extOSInput.readObject();
        xmlData.append("<SEQUENCE>");
        ASN1Sequence objSeq = (ASN1Sequence)derObj;
        Enumeration seqEnum = objSeq.getObjects();
        while (seqEnum.hasMoreElements()) {
            ASN1Encodable currentSeqObj = (ASN1Encodable)seqEnum.nextElement();
            CertExporter.displayObject(currentSeqObj, xmlData);
        }
        xmlData.append("</SEQUENCE>");
    }

    public static void displayObject(ASN1Encodable asn1Object, StringBuilder out) throws IOException {
        if (asn1Object instanceof DERBitString) {
            out.append("<BitString>");
            DERBitString bitStr = (DERBitString)asn1Object;
            byte[] bytes = bitStr.getBytes();
            if (bytes.length > 64) {
                CertExporter.writeEncoded(bytes, out);
            } else {
                String toBinary = CertExporter.toBinary(bytes);
                out.append(StringEscapeUtils.escapeXml11((String)toBinary));
            }
            out.append("</BitString>");
        } else if (asn1Object instanceof DERUniversalString) {
            out.append("<UniversalString>");
            String universal = ((DERUniversalString)asn1Object).getString();
            out.append(StringEscapeUtils.escapeXml11((String)universal));
            out.append("</UniversalString>");
        } else if (asn1Object instanceof DERVisibleString) {
            out.append("<VisibleString>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERVisibleString)asn1Object).getString()));
            out.append("</VisibleString>");
        } else if (asn1Object instanceof DERUTCTime) {
            out.append("<UTCTime>");
            out.append((DERUTCTime)asn1Object);
            out.append("</UTCTime>");
        } else if (asn1Object instanceof DERBMPString) {
            out.append("<BMPString>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERBMPString)asn1Object).getString()));
            out.append("</BMPString>");
        } else if (asn1Object instanceof ASN1Enumerated) {
            out.append("<Enumerated>");
            out.append((ASN1Enumerated)asn1Object);
            out.append("</Enumerated>");
        } else if (asn1Object instanceof ASN1Null) {
            out.append("<Null>");
            out.append((ASN1Null)asn1Object);
            out.append("</Null>");
        } else if (asn1Object instanceof DERExternal) {
            out.append("<External>");
            out.append((DERExternal)asn1Object);
            out.append("</External>");
        } else if (asn1Object instanceof DERGeneralString) {
            out.append("<GeneralString>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERGeneralString)asn1Object).getString()));
            out.append("</GeneralString>");
        } else if (asn1Object instanceof DERGeneralizedTime) {
            out.append("<GeneralizedTime>");
            out.append((DERGeneralizedTime)asn1Object);
            out.append("</GeneralizedTime>");
        } else if (asn1Object instanceof DERIA5String) {
            out.append("<IA5String>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERIA5String)asn1Object).getString()));
            out.append("</IA5String>");
        } else if (asn1Object instanceof DERNumericString) {
            out.append("<NumericString>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERNumericString)asn1Object).getString()));
            out.append("</NumericString>");
        } else if (asn1Object instanceof DERPrintableString) {
            out.append("<PrintableString>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERPrintableString)asn1Object).getString()));
            out.append("</PrintableString>");
        } else if (asn1Object instanceof DERT61String) {
            out.append("<T61String>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERT61String)asn1Object).getString()));
            out.append("</T61String>");
        } else if (asn1Object instanceof DERUTF8String) {
            out.append("<UTF8String>");
            out.append(StringEscapeUtils.escapeXml11((String)((DERUTF8String)asn1Object).getString()));
            out.append("</UTF8String>");
        } else if (asn1Object instanceof ASN1String) {
            out.append("<String>");
            out.append(StringEscapeUtils.escapeXml11((String)((ASN1String)asn1Object).getString()));
            out.append("</String>");
        } else if (asn1Object instanceof ASN1Integer) {
            out.append("<Integer>");
            out.append(String.valueOf(((ASN1Integer)asn1Object).getValue()));
            out.append("</Integer>");
        } else if (asn1Object instanceof ASN1Boolean) {
            out.append("<Boolean>");
            out.append(String.valueOf(((ASN1Boolean)asn1Object).isTrue()));
            out.append("</Boolean>");
        } else if (asn1Object instanceof ASN1ObjectIdentifier) {
            out.append("<OID>");
            out.append(((ASN1ObjectIdentifier)asn1Object).getId());
            out.append("</OID>");
        } else if (asn1Object instanceof ASN1Sequence) {
            out.append("<Sequence>");
            ASN1Sequence objSeq = (ASN1Sequence)asn1Object;
            Enumeration seqEnum = objSeq.getObjects();
            while (seqEnum.hasMoreElements()) {
                ASN1Encodable currentSeqObj = (ASN1Encodable)seqEnum.nextElement();
                CertExporter.displayObject(currentSeqObj, out);
            }
            out.append("</Sequence>");
        } else if (asn1Object instanceof ASN1Set) {
            out.append("<Set>");
            ASN1Set objSet = (ASN1Set)asn1Object;
            Enumeration setEnum = objSet.getObjects();
            while (setEnum.hasMoreElements()) {
                ASN1Encodable currentSetObj = (ASN1Encodable)setEnum.nextElement();
                CertExporter.displayObject(currentSetObj, out);
            }
            out.append("</Set>");
        } else if (asn1Object instanceof DERTaggedObject) {
            DERTaggedObject tagObj = (DERTaggedObject)asn1Object;
            out.append("<TaggedObject TAG=\"" + tagObj.getTagNo() + "\">");
            CertExporter.displayObject((ASN1Encodable)tagObj.getLoadedObject(), out);
            out.append("</TaggedObject>");
        } else if (asn1Object instanceof DEROctetString) {
            DEROctetString octect = (DEROctetString)asn1Object;
            out.append("<OctetString>");
            ASN1Object toASN1Object = CertExporter.toASN1Object(octect.getOctets());
            if (toASN1Object == null) {
                String string = new String(Hex.encode((byte[])((DEROctetString)asn1Object).getOctets()));
                String fromHex = new String(Hex.decode((String)string));
                if (AsciiUtils.isAsciiPrintable(fromHex)) {
                    String escapeXml = StringEscapeUtils.escapeXml11((String)fromHex);
                    out.append(escapeXml);
                } else {
                    out.append(StringEscapeUtils.escapeXml11((String)string));
                }
            } else {
                CertExporter.displayObject((ASN1Encodable)toASN1Object, out);
            }
            out.append("</OctetString>");
        } else if (asn1Object instanceof ASN1Object) {
            out.append("<Object>");
            out.append(asn1Object.toASN1Primitive().toString());
            out.append("</Object>");
        }
    }

    private void writeExtension(boolean critical, String oid, byte[] extValue, StringBuilder xmlData) throws IOException {
        ASN1InputStream extOSInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(extValue));
        ASN1Primitive derObj = extOSInput.readObject();
        ASN1OctetString derOctet = DEROctetString.getInstance((Object)derObj);
        ASN1InputStream extValueInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(derOctet.getOctets()));
        derObj = extValueInput.readObject();
        xmlData.append("<extension oid=\"").append(oid).append("\" critical=\"").append(critical).append("\">");
        CertExporter.displayObject((ASN1Encodable)derObj, xmlData);
        xmlData.append("</extension>");
    }

    private void writeValidateExtension(boolean critical, String oid, byte[] extValue, StringBuilder xmlData) throws IOException {
        ASN1InputStream extOSInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(extValue));
        ASN1Primitive derObj = extOSInput.readObject();
        ASN1OctetString derOctet = DEROctetString.getInstance((Object)derObj);
        ASN1InputStream extValueInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(derOctet.getOctets()));
        derObj = extValueInput.readObject();
        xmlData.append("<OID.").append(oid).append(" critical=\"").append(critical).append("\">");
        this.resetVariables();
        this.displayValidateObject(derObj, xmlData);
        xmlData.append("</OID.").append(oid).append(">");
    }

    private void resetVariables() {
        this.sequence = 0;
        this.tagObj = 0;
        this.DERBitStringi = 0;
        this.DERUniversalStringi = 0;
        this.DERVisibleStringi = 0;
        this.DERUTCTimei = 0;
        this.DERBMPStringi = 0;
        this.DEREnumeratedi = 0;
        this.ASN1Nulli = 0;
        this.DERExternali = 0;
        this.DERGeneralStringi = 0;
        this.DERGeneralizedTimei = 0;
        this.DERIA5Stringi = 0;
        this.DERNumericStringi = 0;
        this.DERPrintableStringi = 0;
        this.DERT61Stringi = 0;
        this.DERUTF8Stringi = 0;
        this.DERStringi = 0;
        this.DERIntegeri = 0;
        this.DERBooleani = 0;
        this.ASN1ObjectIdentifieri = 0;
        this.ASN1Seti = 0;
        this.DEROctetStringi = 0;
        this.DERApplicationSpecifici = 0;
        this.ASN1Objecti = 0;
    }

    public static ASN1Object toASN1Object(byte[] data) throws IOException {
        try {
            return ASN1Primitive.fromByteArray((byte[])data);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String toBinary(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 8);
        for (int i = 0; i < 8 * bytes.length; ++i) {
            sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
        return sb.toString();
    }

    private void displayValidateObject(ASN1Primitive derObj, StringBuilder out) throws IOException {
        if (derObj instanceof DERBitString) {
            int close = ++this.DERBitStringi;
            out.append("<BitString").append(this.DERBitStringi).append(">");
            DERBitString bitStr = (DERBitString)derObj;
            byte[] bytes = bitStr.getBytes();
            if (bytes.length > 64) {
                CertExporter.writeEncoded(bytes, out);
            } else {
                String toBinary = CertExporter.toBinary(bytes);
                out.append(StringEscapeUtils.escapeXml11((String)toBinary));
            }
            out.append("</BitString").append(close).append(">");
        } else if (derObj instanceof DERUniversalString) {
            int close = ++this.DERUniversalStringi;
            out.append("<UniversalString").append(this.DERUniversalStringi).append(">");
            String universal = ((DERUniversalString)derObj).getString();
            out.append(StringEscapeUtils.escapeXml11((String)universal));
            out.append("</UniversalString").append(close).append(">");
        } else if (derObj instanceof DERVisibleString) {
            int close = ++this.DERVisibleStringi;
            out.append("<VisibleString").append(this.DERVisibleStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERVisibleString)derObj).getString()));
            out.append("</VisibleString").append(close).append(">");
        } else if (derObj instanceof DERUTCTime) {
            int close = ++this.DERUTCTimei;
            out.append("<UTCTime").append(this.DERUTCTimei).append(">");
            out.append((DERUTCTime)derObj);
            out.append("</UTCTime").append(close).append(">");
        } else if (derObj instanceof DERBMPString) {
            int close = ++this.DERBMPStringi;
            out.append("<BMPString").append(this.DERBMPStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERBMPString)derObj).getString()));
            out.append("</BMPString").append(close).append(">");
        } else if (derObj instanceof ASN1Enumerated) {
            int close = ++this.DEREnumeratedi;
            out.append("<Enumerated").append(this.DEREnumeratedi).append(">");
            out.append((ASN1Enumerated)derObj);
            out.append("</Enumerated").append(close).append(">");
        } else if (derObj instanceof ASN1Null) {
            int close = ++this.ASN1Nulli;
            out.append("<Null").append(this.ASN1Nulli).append(">");
            out.append((ASN1Null)derObj);
            out.append("</Null").append(close).append(">");
        } else if (derObj instanceof DERExternal) {
            int close = ++this.DERExternali;
            out.append("<External").append(this.DERExternali).append(">");
            out.append((DERExternal)derObj);
            out.append("</External").append(close).append(">");
        } else if (derObj instanceof DERGeneralString) {
            int close = ++this.DERGeneralStringi;
            out.append("<GeneralString").append(this.DERGeneralStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERGeneralString)derObj).getString()));
            out.append("</GeneralString").append(close).append(">");
        } else if (derObj instanceof DERGeneralizedTime) {
            int close = ++this.DERGeneralizedTimei;
            out.append("<GeneralizedTime").append(this.DERGeneralizedTimei).append(">");
            out.append((DERGeneralizedTime)derObj);
            out.append("</GeneralizedTime").append(close).append(">");
        } else if (derObj instanceof DERIA5String) {
            int close = ++this.DERIA5Stringi;
            out.append("<IA5String").append(this.DERIA5Stringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERIA5String)derObj).getString()));
            out.append("</IA5String").append(close).append(">");
        } else if (derObj instanceof DERNumericString) {
            int close = ++this.DERNumericStringi;
            out.append("<NumericString").append(this.DERNumericStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERNumericString)derObj).getString()));
            out.append("</NumericString").append(close).append(">");
        } else if (derObj instanceof DERPrintableString) {
            int close = ++this.DERPrintableStringi;
            out.append("<PrintableString").append(this.DERPrintableStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERPrintableString)derObj).getString()));
            out.append("</PrintableString").append(close).append(">");
        } else if (derObj instanceof DERT61String) {
            int close = ++this.DERT61Stringi;
            out.append("<T61String").append(this.DERT61Stringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERT61String)derObj).getString()));
            out.append("</T61String").append(close).append(">");
        } else if (derObj instanceof DERUTF8String) {
            int close = ++this.DERUTF8Stringi;
            out.append("<UTF8String").append(this.DERUTF8Stringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((DERUTF8String)derObj).getString()));
            out.append("</UTF8String").append(close).append(">");
        } else if (derObj instanceof ASN1String) {
            int close = ++this.DERStringi;
            out.append("<String").append(this.DERStringi).append(">");
            out.append(StringEscapeUtils.escapeXml11((String)((ASN1String)derObj).getString()));
            out.append("</String").append(close).append(">");
        } else if (derObj instanceof ASN1Integer) {
            int close = ++this.DERIntegeri;
            out.append("<Integer").append(this.DERIntegeri).append(">");
            out.append(String.valueOf(((ASN1Integer)derObj).getValue()));
            out.append("</Integer").append(close).append(">");
        } else if (derObj instanceof ASN1Boolean) {
            int close = ++this.DERBooleani;
            out.append("<Boolean").append(this.DERBooleani).append(">");
            out.append(String.valueOf(((ASN1Boolean)derObj).isTrue()));
            out.append("</Boolean").append(close).append(">");
        } else if (derObj instanceof ASN1ObjectIdentifier) {
            int close = ++this.ASN1ObjectIdentifieri;
            out.append("<OID").append(this.ASN1ObjectIdentifieri).append(">");
            out.append(((ASN1ObjectIdentifier)derObj).getId());
            out.append("</OID").append(close).append(">");
        } else if (derObj instanceof ASN1Sequence) {
            int close = ++this.sequence;
            out.append("<Sequence").append(this.sequence).append(">");
            ASN1Sequence objSeq = (ASN1Sequence)derObj;
            Enumeration seqEnum = objSeq.getObjects();
            while (seqEnum.hasMoreElements()) {
                ASN1Encodable currentSeqObj = (ASN1Encodable)seqEnum.nextElement();
                this.displayValidateObject(currentSeqObj.toASN1Primitive(), out);
            }
            out.append("</Sequence").append(close).append(">");
        } else if (derObj instanceof ASN1Set) {
            int close = ++this.ASN1Seti;
            out.append("<Set").append(this.ASN1Seti).append(">");
            ASN1Set objSet = (ASN1Set)derObj;
            Enumeration setEnum = objSet.getObjects();
            while (setEnum.hasMoreElements()) {
                ASN1Encodable currentSetObj = (ASN1Encodable)setEnum.nextElement();
                CertExporter.displayObject(currentSetObj, out);
            }
            out.append("</Set").append(close).append(">");
        } else if (derObj instanceof DERTaggedObject) {
            DERTaggedObject taggedObj = (DERTaggedObject)derObj;
            int close = ++this.tagObj;
            DERTaggedObject dertagObj = (DERTaggedObject)derObj;
            out.append("<TaggedObject").append(this.tagObj).append(" TAG=\"").append(dertagObj.getTagNo()).append("\">");
            this.displayValidateObject(taggedObj.getLoadedObject(), out);
            out.append("</TaggedObject").append(close).append(">");
        } else if (derObj instanceof DEROctetString) {
            DEROctetString octect = (DEROctetString)derObj;
            int close = ++this.DEROctetStringi;
            out.append("<OctetString").append(this.DEROctetStringi).append(">");
            byte[] octets = octect.getOctets();
            ASN1Object toASN1Object = CertExporter.toASN1Object(octets);
            if (toASN1Object == null) {
                String string = new String(Hex.encode((byte[])((DEROctetString)derObj).getOctets()));
                String fromHex = new String(((DEROctetString)derObj).getOctets());
                if (AsciiUtils.isAsciiPrintable(fromHex)) {
                    String escapeXml = StringEscapeUtils.escapeXml11((String)fromHex);
                    out.append(escapeXml);
                } else {
                    out.append(StringEscapeUtils.escapeXml11((String)string));
                }
            } else {
                CertExporter.displayObject((ASN1Encodable)toASN1Object, out);
            }
            out.append("</OctetString").append(close).append(">");
        } else if (derObj instanceof ASN1Object) {
            int close = this.ASN1Objecti++;
            out.append("<Object").append(this.ASN1Objecti).append(">");
            out.append(derObj.toASN1Primitive().toString());
            out.append("</Object").append(close).append(">");
        }
    }
}

