/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.usb.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBController;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.utils.SerialUtils;
import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;

public class WindowsUSBController
implements USBController {
    private static final Logger log = Logger.getLogger(WindowsUSBController.class);
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();

    @Override
    public ArrayList<USB> getUSBUnits() {
        ArrayList<USB> usbs = new ArrayList<USB>();
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            String absolutePath = roots[i].getAbsolutePath();
            if (!WindowsUSBController.isUSB(roots[i])) continue;
            try {
                String serial = SerialUtils.getSerialNumber((String)absolutePath);
                if (serial == null) {
                    System.out.println();
                }
                usbs.add(USBFactory.newUSB(absolutePath, serial));
                continue;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return usbs;
    }

    public static boolean isUSB(File rootFile) {
        String type = fsv.getSystemTypeDescription(rootFile);
        boolean isUSB = fsv.isDrive(rootFile) && (type.toLowerCase().contains("rem") || type.toLowerCase().contains("usb"));
        return isUSB;
    }

    public static boolean isRemovable(String root) {
        String dev = "\\\\.\\" + root;
        return 2 == Kernel32.INSTANCE.GetDriveType(dev);
    }
}

