/*
 * Decompiled with CFR 0.152.
 */
package org.kamranzafar.otp.provider;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.kamranzafar.otp.OTPProviderBase;

public class TOTPProvider
extends OTPProviderBase {
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_ALGORITHM = "HmacSHA512";

    @Override
    public String getName() {
        return "TOTP";
    }

    @Override
    public String generate(String key, String base, int digits) {
        String alg = DEFAULT_ALGORITHM;
        if (this.properties.containsKey(ALGORITHM)) {
            alg = ((String)this.properties.get(ALGORITHM)).toString();
        }
        try {
            return TOTPProvider.generateTOTP(key, base, "" + digits, alg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bArray[i + 1];
        }
        return ret;
    }

    public static String generateTOTP(String key, String time, String returnDigits, String crypto) {
        int codeDigits = Integer.decode(returnDigits);
        Object result = null;
        while (((String)time).length() < 16) {
            time = "0" + (String)time;
        }
        byte[] msg = TOTPProvider.hexStr2Bytes((String)time);
        byte[] k = TOTPProvider.hexStr2Bytes(key);
        byte[] hash = TOTPProvider.hmac_sha(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % (int)Math.pow(10.0, codeDigits);
        result = Integer.toString(otp);
        while (((String)result).length() < codeDigits) {
            result = "0" + (String)result;
        }
        return result;
    }
}

