/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.model.ContainerInfo;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.analyzer.timestamp.TimestampAnalyzer;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerAnalyzer
extends DefaultDocumentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerAnalyzer.class);
    protected ASiCContent asicContent;
    protected List<DocumentAnalyzer> signatureValidators;
    protected List<TimestampAnalyzer> timestampAnalyzers;
    protected List<EvidenceRecordAnalyzer> evidenceRecordAnalyzers;
    private List<ManifestFile> manifestFiles;

    protected AbstractASiCContainerAnalyzer() {
    }

    protected AbstractASiCContainerAnalyzer(DSSDocument document) {
        this.document = document;
        this.asicContent = this.extractEntries();
    }

    protected AbstractASiCContainerAnalyzer(ASiCContent asicContent) {
        this.document = asicContent.getAsicContainer();
        this.asicContent = asicContent;
    }

    public abstract boolean isSupported(ASiCContent var1);

    private ASiCContent extractEntries() {
        DefaultASiCContainerExtractor extractor = this.getContainerExtractor();
        return extractor.extract();
    }

    protected abstract DefaultASiCContainerExtractor getContainerExtractor();

    protected ContainerInfo getContainerInfo() {
        List<DSSDocument> originalSignedDocuments;
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.asicContent.getContainerType());
        containerInfo.setZipComment(this.asicContent.getZipComment());
        DSSDocument mimeTypeDocument = this.asicContent.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray((DSSDocument)mimeTypeDocument));
            containerInfo.setMimeTypeContent(mimeTypeContent);
        }
        if (Utils.isCollectionNotEmpty(originalSignedDocuments = this.asicContent.getSignedDocuments())) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : originalSignedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDescriptions();

    public List<AdvancedSignature> getAllSignatures() {
        List allSignatureList = super.getAllSignatures();
        this.attachExternalTimestamps(allSignatureList);
        return allSignatureList;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatureList = new ArrayList<AdvancedSignature>();
        for (DocumentAnalyzer validator : this.getSignatureAnalyzers()) {
            signatureList.addAll(validator.getSignatures());
        }
        return signatureList;
    }

    protected abstract List<DocumentAnalyzer> getSignatureAnalyzers();

    public ASiCContainerType getContainerType() {
        return this.asicContent.getContainerType();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.asicContent.getAllDocuments();
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.asicContent.getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.asicContent.getSignedDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.asicContent.getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.asicContent.getTimestampDocuments();
    }

    public List<DSSDocument> getEvidenceRecordDocuments() {
        return this.asicContent.getEvidenceRecordDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.asicContent.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getEvidenceRecordManifestDocuments() {
        return this.asicContent.getEvidenceRecordManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.asicContent.getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.asicContent.getContainerDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.asicContent.getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.asicContent.getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = this.getManifestFilesDescriptions();
        }
        return this.manifestFiles;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        List<DSSDocument> containerDocuments = this.asicContent.getContainerDocuments();
        if (Utils.isCollectionNotEmpty(containerDocuments)) {
            return containerDocuments;
        }
        return retrievedDocs;
    }

    protected List<EvidenceRecord> buildDetachedEvidenceRecords() {
        ArrayList<EvidenceRecord> embeddedEvidenceRecords = new ArrayList<EvidenceRecord>();
        for (EvidenceRecordAnalyzer evidenceRecordAnalyzer : this.getEvidenceRecordAnalyzers()) {
            EvidenceRecord evidenceRecord = this.getEvidenceRecord(evidenceRecordAnalyzer);
            if (evidenceRecord == null) continue;
            embeddedEvidenceRecords.add(evidenceRecord);
        }
        ArrayList<EvidenceRecord> detachedEvidenceRecords = new ArrayList<EvidenceRecord>(super.buildDetachedEvidenceRecords());
        this.attachExternalEvidenceRecords(embeddedEvidenceRecords, detachedEvidenceRecords);
        detachedEvidenceRecords.addAll(embeddedEvidenceRecords);
        return detachedEvidenceRecords;
    }

    protected void attachExternalEvidenceRecords(List<EvidenceRecord> embeddedEvidenceRecords, List<EvidenceRecord> detachedEvidenceRecords) {
        if (Utils.isCollectionNotEmpty(embeddedEvidenceRecords)) {
            for (EvidenceRecord coveredEvidenceRecord : embeddedEvidenceRecords) {
                for (EvidenceRecord coveringEvidenceRecord : embeddedEvidenceRecords) {
                    if (!this.coversEvidenceRecord(coveredEvidenceRecord, coveringEvidenceRecord)) continue;
                    coveredEvidenceRecord.addExternalEvidenceRecord(coveringEvidenceRecord);
                }
                for (EvidenceRecord coveringEvidenceRecord : detachedEvidenceRecords) {
                    coveredEvidenceRecord.addExternalEvidenceRecord(coveringEvidenceRecord);
                }
            }
        }
    }

    protected List<EvidenceRecordAnalyzer> getEvidenceRecordAnalyzers() {
        if (this.evidenceRecordAnalyzers == null) {
            this.evidenceRecordAnalyzers = new ArrayList<EvidenceRecordAnalyzer>();
            for (DSSDocument evidenceRecordDocument : this.getEvidenceRecordDocuments()) {
                EvidenceRecordAnalyzer evidenceRecordAnalyzer = this.getEvidenceRecordAnalyzer(evidenceRecordDocument);
                if (evidenceRecordAnalyzer == null) continue;
                this.evidenceRecordAnalyzers.add(evidenceRecordAnalyzer);
            }
        }
        return this.evidenceRecordAnalyzers;
    }

    private EvidenceRecordAnalyzer getEvidenceRecordAnalyzer(DSSDocument evidenceRecordDocument) {
        try {
            ManifestFile manifestFile = null;
            List<Object> detachedContents = this.getAllDocuments();
            DSSDocument evidenceRecordManifest = ASiCManifestParser.getLinkedManifest(this.getEvidenceRecordManifestDocuments(), evidenceRecordDocument.getName());
            if (evidenceRecordManifest != null) {
                manifestFile = this.getValidatedManifestFile(evidenceRecordManifest);
            }
            if (ASiCUtils.isASiCSContainer(this.asicContent)) {
                List<DSSDocument> rootLevelSignedDocuments;
                if (manifestFile != null) {
                    LOG.warn("A linked ASiCEvidenceRecordManifest '{}' was found for an evidence record with name '{}'. The manifest processing is ignored, as not required for ASiC-S format.", (Object)manifestFile.getFilename(), (Object)evidenceRecordDocument.getName());
                    manifestFile = null;
                }
                if (Utils.collectionSize(rootLevelSignedDocuments = ASiCUtils.getRootLevelSignedDocuments(this.asicContent)) == 1) {
                    detachedContents = rootLevelSignedDocuments;
                } else {
                    LOG.warn("'{}' documents found at the root level. Not applicable for an ASiC-S container!", (Object)Utils.collectionSize(rootLevelSignedDocuments));
                    detachedContents = Collections.emptyList();
                }
            } else if (manifestFile == null) {
                LOG.warn("A linked ASiCEvidenceRecordManifest is required for ASiC-E container but was not found for an evidence record with name '{}'!", (Object)evidenceRecordDocument.getName());
                detachedContents = Collections.emptyList();
                manifestFile = new ManifestFile();
            }
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument((DSSDocument)evidenceRecordDocument);
            this.assertEvidenceRecordDocumentExtensionMatch(evidenceRecordDocument, evidenceRecordAnalyzer.getEvidenceRecordType());
            evidenceRecordAnalyzer.setDetachedContents(detachedContents);
            evidenceRecordAnalyzer.setManifestFile(manifestFile);
            evidenceRecordAnalyzer.setCertificateVerifier(this.certificateVerifier);
            evidenceRecordAnalyzer.setEvidenceRecordOrigin(EvidenceRecordOrigin.CONTAINER);
            return evidenceRecordAnalyzer;
        }
        catch (Exception e) {
            LOG.warn("Unable to load EvidenceRecordValidator for an evidence record document with name '{}' : {}", new Object[]{evidenceRecordDocument.getName(), e.getMessage(), e});
            return null;
        }
    }

    protected void assertEvidenceRecordDocumentExtensionMatch(DSSDocument evidenceRecordDocument, EvidenceRecordTypeEnum evidenceRecordTypeEnum) {
        switch (evidenceRecordTypeEnum) {
            case XML_EVIDENCE_RECORD: {
                if (evidenceRecordDocument.getName() == null || evidenceRecordDocument.getName().endsWith(".xml")) break;
                throw new DSSException("Document containing an XMLERS evidence record shall end with '.xml' extension!");
            }
            case ASN1_EVIDENCE_RECORD: {
                if (evidenceRecordDocument.getName() == null || evidenceRecordDocument.getName().endsWith(".ers")) break;
                throw new DSSException("Document containing an ERS evidence record shall end with '.ers' extension!");
            }
            default: {
                throw new UnsupportedOperationException(String.format("The evidence record type '%s' is not supported!", evidenceRecordTypeEnum));
            }
        }
    }

    protected boolean coversSignature(AdvancedSignature signature, EvidenceRecord evidenceRecord) {
        ManifestFile evidenceRecordManifest = evidenceRecord.getManifestFile();
        if (evidenceRecordManifest == null) {
            return true;
        }
        return this.coversFile(evidenceRecordManifest, signature.getFilename());
    }

    private boolean coversEvidenceRecord(EvidenceRecord coveredEvidenceRecord, EvidenceRecord coveringEvidenceRecord) {
        ManifestFile evidenceRecordManifest = coveringEvidenceRecord.getManifestFile();
        if (evidenceRecordManifest == null) {
            return false;
        }
        return this.coversFile(evidenceRecordManifest, coveredEvidenceRecord.getFilename());
    }

    private boolean coversFile(ManifestFile manifestFile, String filename) {
        if (manifestFile != null) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!Utils.areStringsEqual((String)filename, (String)manifestEntry.getUri())) continue;
                return true;
            }
        }
        return false;
    }

    protected ManifestFile getValidatedManifestFile(DSSDocument manifest) {
        List<ManifestFile> allManifestFiles = this.getManifestFiles();
        if (Utils.isCollectionNotEmpty(allManifestFiles)) {
            for (ManifestFile manifestFile : allManifestFiles) {
                if (!Utils.areStringsEqual((String)manifest.getName(), (String)manifestFile.getFilename())) continue;
                return manifestFile;
            }
        }
        return null;
    }

    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getDocumentName();
        return fileName == null || !ASiCUtils.isSignature(fileName) && !ASiCUtils.isTimestamp(fileName) && !ASiCUtils.isEvidenceRecord(fileName);
    }
}

