/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.extract;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractorFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultASiCContainerExtractor
implements ASiCContainerExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultASiCContainerExtractor.class);
    private final DSSDocument asicContainer;

    protected DefaultASiCContainerExtractor(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    public static ASiCContainerExtractor fromDocument(DSSDocument asicContainer) {
        Objects.requireNonNull(asicContainer, "ASiC container cannot be null!");
        ServiceLoader<ASiCContainerExtractorFactory> serviceLoaders = ServiceLoader.load(ASiCContainerExtractorFactory.class);
        for (ASiCContainerExtractorFactory factory : serviceLoaders) {
            if (!factory.isSupported(asicContainer)) continue;
            return factory.create(asicContainer);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    @Override
    public ASiCContent extract() {
        ASiCContent result = this.zipParsing(this.asicContainer);
        result.setZipComment(ASiCUtils.getZipComment(this.asicContainer));
        result.setContainerType(ASiCUtils.getContainerType(result));
        result.setContainerDocuments(this.getContainerDocuments(result));
        return result;
    }

    private ASiCContent zipParsing(DSSDocument asicContainer) {
        ASiCContent result = new ASiCContent();
        result.setAsicContainer(asicContainer);
        List<DSSDocument> documents = ZipUtils.getInstance().extractContainerContent(asicContainer);
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalInputException(String.format("The provided file with name '%s' does not contain documents inside. Probably file has an unsupported format or has been corrupted. The signature validation is not possible", asicContainer.getName()));
        }
        for (DSSDocument currentDocument : documents) {
            String entryName = currentDocument.getName();
            if (this.isMetaInfFolder(entryName)) {
                if (this.isAllowedSignature(entryName)) {
                    result.getSignatureDocuments().add(currentDocument);
                    continue;
                }
                if (this.isAllowedManifest(entryName)) {
                    result.getManifestDocuments().add(currentDocument);
                    continue;
                }
                if (this.isAllowedArchiveManifest(entryName)) {
                    result.getArchiveManifestDocuments().add(currentDocument);
                    continue;
                }
                if (this.isAllowedEvidenceRecordManifest(entryName)) {
                    result.getEvidenceRecordManifestDocuments().add(currentDocument);
                    continue;
                }
                if (this.isAllowedTimestamp(entryName)) {
                    result.getTimestampDocuments().add(currentDocument);
                    continue;
                }
                if (this.isAllowedEvidenceRecord(entryName)) {
                    result.getEvidenceRecordDocuments().add(currentDocument);
                    continue;
                }
                if (this.isFolder(entryName)) continue;
                result.getUnsupportedDocuments().add(currentDocument);
                continue;
            }
            if (!this.isFolder(entryName)) {
                if (ASiCUtils.isMimetype(entryName)) {
                    result.setMimeTypeDocument(currentDocument);
                    continue;
                }
                result.getSignedDocuments().add(currentDocument);
                continue;
            }
            result.getFolders().add(currentDocument);
        }
        if (Utils.isCollectionNotEmpty(result.getUnsupportedDocuments())) {
            LOG.warn("Unsupported files : {}", result.getUnsupportedDocuments());
        }
        return result;
    }

    private List<DSSDocument> getContainerDocuments(ASiCContent asicContent) {
        ArrayList<DSSDocument> containerDocuments = new ArrayList<DSSDocument>();
        if (ASiCUtils.isASiCSContainer(asicContent)) {
            for (DSSDocument signerDocument : asicContent.getRootLevelSignedDocuments()) {
                if (Utils.isCollectionNotEmpty(containerDocuments)) {
                    LOG.warn("More than one ZIP archive found on a root level of the ASiC-S container! Extraction of embedded documents not possible.");
                    return Collections.emptyList();
                }
                if (!ASiCUtils.isZip(signerDocument)) continue;
                containerDocuments.addAll(ZipUtils.getInstance().extractContainerContent(signerDocument));
            }
        }
        return containerDocuments;
    }

    private boolean isMetaInfFolder(String entryName) {
        return entryName.startsWith("META-INF/");
    }

    private boolean isFolder(String entryName) {
        return entryName.endsWith("/");
    }

    protected abstract boolean isAllowedManifest(String var1);

    protected abstract boolean isAllowedArchiveManifest(String var1);

    protected abstract boolean isAllowedEvidenceRecordManifest(String var1);

    protected abstract boolean isAllowedSignature(String var1);

    protected abstract boolean isAllowedTimestamp(String var1);

    protected abstract boolean isAllowedEvidenceRecord(String var1);
}

