/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCEvidenceRecordFilenameFactory;
import eu.europa.esig.dss.asic.common.AbstractASiCManifestBuilder;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilter;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilterFactory;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;

public class ASiCEvidenceRecordManifestBuilder
extends AbstractASiCManifestBuilder {
    private ASiCEvidenceRecordFilenameFactory evidenceRecordFilenameFactory;

    public ASiCEvidenceRecordManifestBuilder(DSSDocument asicContainer, DigestAlgorithm digestAlgorithm, String evidenceRecordFilename) {
        this(ASiCEvidenceRecordManifestBuilder.toASiCContent(asicContainer), digestAlgorithm, evidenceRecordFilename);
    }

    private static ASiCContent toASiCContent(DSSDocument asicContainer) {
        try {
            ASiCContainerExtractor asicContainerExtractor = DefaultASiCContainerExtractor.fromDocument(asicContainer);
            return asicContainerExtractor.extract();
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unsupported ASiC or document type! Returned error : %s", e.getMessage()), (Throwable)e);
        }
    }

    public ASiCEvidenceRecordManifestBuilder(ASiCContent asicContent, DigestAlgorithm digestAlgorithm, String evidenceRecordFilename) {
        super(asicContent, evidenceRecordFilename, digestAlgorithm);
    }

    @Override
    protected MimeType getSigReferenceMimeType() {
        return null;
    }

    @Override
    protected ASiCContentDocumentFilter initDefaultAsicContentDocumentFilter() {
        return ASiCContentDocumentFilterFactory.archiveDocumentsFilter(new String[0]);
    }

    @Override
    public ASiCEvidenceRecordManifestBuilder setAsicContentDocumentFilter(ASiCContentDocumentFilter asicContentDocumentFilter) {
        return (ASiCEvidenceRecordManifestBuilder)super.setAsicContentDocumentFilter(asicContentDocumentFilter);
    }

    public ASiCEvidenceRecordManifestBuilder setEvidenceRecordFilenameFactory(ASiCEvidenceRecordFilenameFactory evidenceRecordFilenameFactory) {
        this.evidenceRecordFilenameFactory = evidenceRecordFilenameFactory;
        return this;
    }

    @Override
    protected String getManifestFilename() {
        if (this.evidenceRecordFilenameFactory != null) {
            return this.evidenceRecordFilenameFactory.getEvidenceRecordManifestFilename(this.asicContent);
        }
        return null;
    }
}

