/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ContainerEntryDocument;
import eu.europa.esig.dss.asic.common.DSSZipEntry;
import eu.europa.esig.dss.asic.common.DSSZipEntryDocument;
import eu.europa.esig.dss.asic.common.FileArchiveEntry;
import eu.europa.esig.dss.asic.common.ZipContainerHandler;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureContainerHandler
implements ZipContainerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecureContainerHandler.class);
    public static final String MIMETYPE = "mimetype";
    private long threshold = 1000000L;
    private long maxCompressionRatio = 100L;
    private int maxAllowedFilesAmount = 1000;
    private int maxMalformedFiles = 100;
    private boolean extractComments = false;
    private long byteCounter = 0L;
    private int malformedFilesCounter = 0;
    private DSSResourcesHandlerBuilder resourcesHandlerBuilder = new InMemoryResourcesHandlerBuilder();

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setMaxCompressionRatio(long maxCompressionRatio) {
        this.maxCompressionRatio = maxCompressionRatio;
    }

    public void setMaxAllowedFilesAmount(int maxAllowedFilesAmount) {
        this.maxAllowedFilesAmount = maxAllowedFilesAmount;
    }

    public void setMaxMalformedFiles(int maxMalformedFiles) {
        this.maxMalformedFiles = maxMalformedFiles;
    }

    public void setExtractComments(boolean extractComments) {
        this.extractComments = extractComments;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        Objects.requireNonNull(resourcesHandlerBuilder, "DSSResourcesHandlerBuilder cannot be null!");
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    @Override
    public List<DSSDocument> extractContainerContent(DSSDocument zipArchive) {
        this.resetCounters();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (this.isInFileProcessingSupported(zipArchive)) {
            FileDocument zipFileDocument = (FileDocument)zipArchive;
            List<ZipEntry> zipEntries = this.extractZipEntries((DSSDocument)zipFileDocument);
            if (!this.malformedEntriesDetected()) {
                for (ZipEntry zipEntry : zipEntries) {
                    result.add(new FileArchiveEntry(zipFileDocument, zipEntry));
                }
                return result;
            }
            LOG.warn("The archive with name '{}' contains malformed entries. Unable to parse with ZipFile. Continue with ZipInputStream...", (Object)zipArchive.getName());
        }
        long containerSize = DSSUtils.getFileByteSize((DSSDocument)zipArchive);
        try (InputStream is = zipArchive.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            DSSDocument document;
            while ((document = this.getNextDocument(zis, containerSize)) != null) {
                result.add(document);
                this.assertCollectionSizeValid(result);
            }
        }
        catch (IOException e) {
            throw new IllegalInputException("Unable to extract content from zip archive", (Throwable)e);
        }
        return result;
    }

    private boolean isInFileProcessingSupported(DSSDocument zipArchive) {
        if (zipArchive instanceof FileDocument) {
            boolean bl;
            ZipFile zipFile = new ZipFile(((FileDocument)zipArchive).getFile());
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Unable to process archive with name '{}' using in-file processing. Continue validation using in-memory processing. Reason : {}", new Object[]{zipArchive.getName(), e.getMessage(), e});
                }
            }
            zipFile.close();
            return bl;
        }
        return false;
    }

    private boolean malformedEntriesDetected() {
        return this.malformedFilesCounter > 0;
    }

    private DSSDocument getNextDocument(ZipInputStream zis, long containerSize) {
        ZipEntry entry = this.getNextValidEntry(zis);
        if (entry != null) {
            return this.getCurrentEntryDocument(zis, entry, containerSize);
        }
        return null;
    }

    @Override
    public List<String> extractEntryNames(DSSDocument zipArchive) {
        List<ZipEntry> zipEntries = this.extractZipEntries(zipArchive);
        if (Utils.isCollectionNotEmpty(zipEntries)) {
            return zipEntries.stream().map(ZipEntry::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<ZipEntry> extractZipEntries(DSSDocument zipArchive) {
        this.resetCounters();
        long containerSize = DSSUtils.getFileByteSize((DSSDocument)zipArchive);
        long allowedSize = containerSize * this.maxCompressionRatio;
        ArrayList<ZipEntry> result = new ArrayList<ZipEntry>();
        try (InputStream is = zipArchive.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = this.getNextValidEntry(zis)) != null) {
                result.add(entry);
                this.assertCollectionSizeValid(result);
                this.secureSkip(zis, allowedSize);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to extract entries from zip archive", e);
        }
        this.extractComments(zipArchive, result);
        return result;
    }

    private void extractComments(DSSDocument zipArchive, List<ZipEntry> zipEntries) {
        if (this.extractComments && zipArchive instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)zipArchive;
            try (ZipFile zipFile = new ZipFile(fileDocument.getFile());){
                for (ZipEntry zipEntry : zipEntries) {
                    ZipEntry zipFileEntry = zipFile.getEntry(zipEntry.getName());
                    zipEntry.setComment(zipFileEntry.getComment());
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to read comments from zip archive", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument createZipArchive(List<DSSDocument> containerEntries, Date creationTime, String zipComment) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected DSSResourcesHandler instantiateResourcesHandler() throws IOException {
        return this.resourcesHandlerBuilder.createResourcesHandler();
    }

    protected void buildZip(List<DSSDocument> containerEntries, Date creationTime, String zipComment, ZipOutputStream zos) throws IOException {
        for (DSSDocument entry : containerEntries) {
            ZipEntry zipEntry = this.getZipEntry(entry, creationTime);
            zos.putNextEntry(zipEntry);
            InputStream entryIS = entry.openStream();
            try {
                this.secureCopy(entryIS, zos, -1L);
            }
            finally {
                if (entryIS == null) continue;
                entryIS.close();
            }
        }
        if (Utils.isStringNotEmpty((String)zipComment)) {
            zos.setComment(zipComment);
        }
        zos.finish();
    }

    protected ZipEntry getZipEntry(DSSDocument entry, Date creationTime) {
        DSSZipEntry zipEntryWrapper;
        if (entry instanceof DSSZipEntryDocument) {
            DSSZipEntryDocument dssZipEntry = (DSSZipEntryDocument)entry;
            zipEntryWrapper = dssZipEntry.getZipEntry();
        } else {
            zipEntryWrapper = new DSSZipEntry(entry.getName());
        }
        ZipEntry zipEntry = zipEntryWrapper.createZipEntry();
        this.ensureCompressionMethod(zipEntry, entry);
        this.ensureTime(zipEntry, creationTime);
        return zipEntry;
    }

    private void ensureCompressionMethod(ZipEntry zipEntry, DSSDocument content) {
        if (MIMETYPE.equals(zipEntry.getName())) {
            if (zipEntry.getMethod() != -1 && 0 != zipEntry.getMethod()) {
                LOG.warn("'mimetype' shall not be compressed! Compression method in its ZIP header will be set to zero.");
            }
            zipEntry.setMethod(0);
        }
        if (0 == zipEntry.getMethod()) {
            this.addStoredContent(zipEntry, content);
        }
    }

    private void addStoredContent(ZipEntry zipEntry, DSSDocument content) {
        long size = 0L;
        CRC32 crc = new CRC32();
        try (InputStream is = content.openStream();){
            int nbRead;
            byte[] buffer = new byte[8192];
            while ((nbRead = is.read(buffer)) != -1) {
                crc.update(buffer, 0, nbRead);
                size += (long)nbRead;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to process CRC32 computation", (Throwable)e);
        }
        zipEntry.setSize(size);
        zipEntry.setCompressedSize(size);
        zipEntry.setCrc(crc.getValue());
    }

    private void ensureTime(ZipEntry zipEntry, Date creationTime) {
        if (creationTime != null) {
            zipEntry.setTime(creationTime.getTime());
        }
    }

    private void resetCounters() {
        this.byteCounter = 0L;
        this.malformedFilesCounter = 0;
    }

    private ZipEntry getNextValidEntry(ZipInputStream zis) {
        while (this.malformedFilesCounter < this.maxMalformedFiles) {
            try {
                return zis.getNextEntry();
            }
            catch (Exception e) {
                LOG.warn("ZIP container contains a malformed, corrupted or not accessible entry! The entry is skipped. Reason: [{}]", (Object)e.getMessage());
                ++this.malformedFilesCounter;
                this.closeEntry(zis);
            }
        }
        throw new DSSException("Unable to retrieve a valid ZipEntry (" + this.maxMalformedFiles + " tries)");
    }

    private void closeEntry(ZipInputStream zis) {
        try {
            zis.closeEntry();
        }
        catch (IOException e) {
            throw new DSSException("Unable to close entry", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private DSSDocument getCurrentEntryDocument(ZipInputStream zis, ZipEntry entry, long containerSize) {
        long allowedSize = containerSize * this.maxCompressionRatio;
        try (DSSResourcesHandler dssResourcesHandler = this.instantiateResourcesHandler();){
            ContainerEntryDocument containerEntryDocument;
            block14: {
                OutputStream os = dssResourcesHandler.createOutputStream();
                try {
                    this.secureCopy(zis, os, allowedSize);
                    os.flush();
                    DSSDocument currentDocument = dssResourcesHandler.writeToDSSDocument();
                    String fileName = entry.getName();
                    currentDocument.setName(entry.getName());
                    currentDocument.setMimeType(MimeType.fromFileName((String)fileName));
                    containerEntryDocument = new ContainerEntryDocument(currentDocument, new DSSZipEntry(entry));
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return containerEntryDocument;
        }
        catch (IOException e) {
            this.closeEntry(zis);
            throw new DSSException(String.format("Unable to read an entry binaries. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected void secureCopy(InputStream is, OutputStream os, long allowedSize) throws IOException {
        int nRead;
        byte[] data = new byte[8192];
        while ((nRead = is.read(data)) != -1) {
            this.byteCounter += (long)nRead;
            this.assertExtractEntryLengthValid(allowedSize);
            os.write(data, 0, nRead);
        }
    }

    protected void secureSkip(InputStream is, long allowedSize) throws IOException {
        long nRead;
        while ((nRead = is.skip(8192L)) > 0L) {
            this.byteCounter += nRead;
            this.assertExtractEntryLengthValid(allowedSize);
        }
    }

    private void assertExtractEntryLengthValid(long allowedSize) {
        if (allowedSize != -1L && this.byteCounter > this.threshold && this.byteCounter > allowedSize) {
            throw new IllegalInputException("Zip Bomb detected in the ZIP container. Validation is interrupted.");
        }
    }

    private void assertCollectionSizeValid(Collection<?> collection) {
        if (collection.size() > this.maxAllowedFilesAmount) {
            throw new IllegalInputException("Too many files detected. Cannot extract ASiC content from the file.");
        }
    }
}

