/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.validation.XAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESOCSPSource.class);
    private final Element signatureElement;
    private final XAdESPath xadesPaths;

    public XAdESOCSPSource(Element signatureElement, XAdESPath xadesPaths) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xadesPaths, "XAdESPaths cannot be null");
        this.signatureElement = signatureElement;
        this.xadesPaths = xadesPaths;
        this.appendContainedOCSPResponses();
    }

    private void appendContainedOCSPResponses() {
        this.collectValues(this.xadesPaths.getRevocationValuesPath(), RevocationOrigin.REVOCATION_VALUES);
        this.collectValues(this.xadesPaths.getAttributeRevocationValuesPath(), RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        this.collectValues(this.xadesPaths.getTimeStampValidationDataRevocationValuesPath(), RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
        this.collectValues(this.xadesPaths.getAnyValidationDataRevocationValuesPath(), RevocationOrigin.ANY_VALIDATION_DATA);
        this.collectRefs(this.xadesPaths.getCompleteRevocationRefsPath(), RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        this.collectRefs(this.xadesPaths.getAttributeRevocationRefsPath(), RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    private void collectValues(String revocationValuesPath, RevocationOrigin origin) {
        if (revocationValuesPath == null) {
            return;
        }
        NodeList revocationValuesNodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)revocationValuesPath);
        for (int i = 0; i < revocationValuesNodeList.getLength(); ++i) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.item(i);
            NodeList ocspValueNodes = DomUtils.getNodeList((Node)revocationValuesElement, (String)this.xadesPaths.getCurrentOCSPValuesChildren());
            for (int ii = 0; ii < ocspValueNodes.getLength(); ++ii) {
                Element ocspValueEl = (Element)ocspValueNodes.item(ii);
                if (ocspValueEl == null) continue;
                this.convertAndAppend(ocspValueEl.getTextContent(), origin);
            }
        }
    }

    private void collectRefs(String revocationRefsPath, RevocationRefOrigin revocationRefOrigin) {
        if (revocationRefsPath == null) {
            return;
        }
        NodeList revocationRefsNodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)revocationRefsPath);
        for (int i = 0; i < revocationRefsNodeList.getLength(); ++i) {
            Element revocationRefsElement = (Element)revocationRefsNodeList.item(i);
            NodeList ocspRefNodes = DomUtils.getNodeList((Node)revocationRefsElement, (String)this.xadesPaths.getCurrentOCSPRefsChildren());
            for (int ii = 0; ii < ocspRefNodes.getLength(); ++ii) {
                OCSPRef ocspRef;
                Element ocspRefElement = (Element)ocspRefNodes.item(ii);
                if (ocspRefElement == null || (ocspRef = XAdESRevocationRefExtractionUtils.createOCSPRef(this.xadesPaths, ocspRefElement)) == null) continue;
                this.addRevocationReference((RevocationRef)ocspRef, revocationRefOrigin);
            }
        }
    }

    private void convertAndAppend(String ocspValue, RevocationOrigin origin) {
        try {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)DSSRevocationUtils.loadOCSPBase64Encoded((String)ocspValue)), origin);
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve OCSP response from '{}' : {}", new Object[]{ocspValue, e.getMessage(), e});
        }
    }
}

