/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.model.DSSException;
import java.io.IOException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.w3c.dom.Node;

public class DSSTransformOutput {
    private final XMLSignatureInput xmlSignatureInput;

    public DSSTransformOutput(XMLSignatureInput xmlSignatureInput) {
        this.xmlSignatureInput = xmlSignatureInput;
    }

    public DSSTransformOutput(Node node) {
        this(new XMLSignatureInput(node));
    }

    protected XMLSignatureInput getXmlSignatureInput() {
        return this.xmlSignatureInput;
    }

    public byte[] getBytes() {
        try {
            return this.xmlSignatureInput.getBytes();
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException(String.format("Cannot extract Transform output bytes. Reason : [%s]", e.getMessage()), e);
        }
    }
}

