/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades.params;

import com.anf.cryptotoken.sign.commitments.ANFCommitmentType;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.impl.AbstractSignatureParams;
import com.anf.cryptotoken.sign.xades.params.XadesParams;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.util.List;

public class XadesSignatureParams
extends AbstractSignatureParams<XAdESSignatureParameters, XAdESTimestampParameters>
implements XadesParams {
    public XadesSignatureParams(CertificateParams certificateParams, XAdESSignatureParameters params) {
        super(certificateParams, params);
    }

    public XadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, Policy signaturePolicy, List<ANFCommitmentType> commitments) {
        super(certificateParams, digestAlg, level, packaging, signaturePolicy, commitments);
    }

    public XadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, Policy signaturePolicy) {
        super(certificateParams, digestAlg, level, packaging, signaturePolicy);
    }

    public XadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging) {
        super(certificateParams, digestAlg, level, packaging, null);
    }

    @Override
    protected XAdESSignatureParameters createParameters() {
        XAdESSignatureParameters params = new XAdESSignatureParameters();
        XAdESTimestampParameters timestampParameters = new XAdESTimestampParameters(this.digestAlg);
        params.setArchiveTimestampParameters((SerializableTimestampParameters)timestampParameters);
        params.setContentTimestampParameters((SerializableTimestampParameters)timestampParameters);
        params.setSignatureTimestampParameters((SerializableTimestampParameters)timestampParameters);
        params.setEmbedXML(this.packaging == SignaturePackaging.ENVELOPING);
        return params;
    }
}

