/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import com.anf.cryptotoken.sign.xades.XMLDSigService;
import com.anf.cryptotoken.sign.xades.XadesSignatureImpl;
import com.anf.cryptotoken.sign.xades.params.XadesParams;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class XMLDSigSignatureImpl
extends XadesSignatureImpl {
    public XMLDSigSignatureImpl() {
    }

    public XMLDSigSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    @Override
    public void sign(XadesParams params, File src, File dest) {
        XMLDSigService service = new XMLDSigService((CertificateVerifier)this.commonCertificateVerifier);
        this.sign((XAdESService)service, params, src, dest);
    }

    @Override
    public void sign(XadesParams params, InputStream input, OutputStream output) {
        try {
            XMLDSigService service = new XMLDSigService((CertificateVerifier)this.commonCertificateVerifier);
            InMemoryDocument src = new InMemoryDocument(input);
            super.sign((XAdESService)service, params, (DSSDocument)src, output);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    @Override
    public void extend(XadesParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            XMLDSigService service = new XMLDSigService((CertificateVerifier)this.commonCertificateVerifier);
            service.setTspSource(params.getTspSource());
            DSSDocument extendDocument = service.extendDocument((DSSDocument)new FileDocument(src), params.getParameters());
            try (InputStream in = extendDocument.openStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }
}

