/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class TestXades1 {
    public static void main(String[] args) throws DSSException, IOException {
        File ksFile = new File("/media/aramis/Datos/TRABAJO/MIO/ANF/Proyectos/ANFCryptoToken/test-pfx/emitidos/123845988-99832441.pfx");
        String pass = "12341234";
        try (Pkcs12SignatureToken token = new Pkcs12SignatureToken(ksFile, new KeyStore.PasswordProtection(pass.toCharArray()));){
            List keys = token.getKeys();
            DSSPrivateKeyEntry privateKey = null;
            for (DSSPrivateKeyEntry entry : keys) {
                X509Certificate cert = entry.getCertificate().getCertificate();
                if (!cert.getSubjectX500Principal().toString().contains("FIRMA") && !cert.getSubjectX500Principal().toString().contains("SELLO")) continue;
                privateKey = entry;
                break;
            }
            FileDocument toBeSigned = new FileDocument("prueba.xml");
            XAdESSignatureParameters params = new XAdESSignatureParameters();
            params.setSignatureLevel(SignatureLevel.XAdES_BASELINE_B);
            params.setSignaturePackaging(SignaturePackaging.ENVELOPED);
            params.setSigningCertificate(privateKey.getCertificate());
            params.setCertificateChain(privateKey.getCertificateChain());
            params.bLevel().setSigningDate(new Date());
            CommonCertificateVerifier commonCertificateVerifier = new CommonCertificateVerifier();
            XAdESService service = new XAdESService((CertificateVerifier)commonCertificateVerifier);
            ToBeSigned dataToSign = service.getDataToSign((DSSDocument)toBeSigned, params);
            SignatureValue signatureValue = token.sign(dataToSign, params.getDigestAlgorithm(), privateKey);
            DSSDocument signedDocument = service.signDocument((DSSDocument)toBeSigned, params, signatureValue);
            Utils.copy((InputStream)signedDocument.openStream(), (OutputStream)new FileOutputStream("signed.xml"));
        }
    }
}

