/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;

public class PdfUtils {
    private static final Logger log = Logger.getLogger(PdfUtils.class);

    public static void createPdfLayers(File pdfSrc, Map<String, File> layers, String selected) throws IOException {
        try (PDDocument pdfDoc = new PDDocument();){
            int max = 10000;
            HashMap<String, PDDocument> layerMap = new HashMap<String, PDDocument>();
            String first = null;
            PDOptionalContentProperties ocProps = new PDOptionalContentProperties();
            pdfDoc.getDocumentCatalog().setOCProperties(ocProps);
            for (int pages = 0; pages < max; ++pages) {
                PDPage page = new PDPage();
                pdfDoc.addPage(page);
                for (Map.Entry<String, File> layer : layers.entrySet()) {
                    if (first == null) {
                        first = layer.getKey();
                    }
                    PDOptionalContentGroup ocg = new PDOptionalContentGroup(layer.getKey());
                    ocProps.addGroup(ocg);
                    PDDocument layerDoc = layerMap.computeIfAbsent(layer.getKey(), key -> {
                        try {
                            return Loader.loadPDF((File)((File)layer.getValue()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    PDPage srcPage = layerDoc.getPage(0);
                    pdfDoc.importPage(srcPage);
                    max = Math.min(max, layerDoc.getNumberOfPages());
                }
            }
            if (layers != null && selected != null && layers.get(selected) == null) {
                selected = first;
            }
            String javascript = "function mostrarCapa(nombre){var ocg = this.getOCGs();for(var x = 0; x < ocg.length; x++){if(ocg[x].name == nombre){ ocg[x].state = true; }else{ ocg[x].state = false; }}} mostrarCapa('" + selected + "');";
            PDActionJavaScript jsAction = new PDActionJavaScript(javascript);
            pdfDoc.getDocumentCatalog().setOpenAction((PDDestinationOrAction)jsAction);
            for (PDDocument layerDoc : layerMap.values()) {
                layerDoc.close();
            }
            pdfDoc.save(pdfSrc);
        }
    }

    public static void addAndRepeatPdfPage(File src, File add, int page, int repeat) throws IOException {
        try (PDDocument pdfDoc = new PDDocument();
             PDDocument srcDoc = Loader.loadPDF((File)src);){
            PDPage srcPage = srcDoc.getPage(page - 1);
            for (int i = 0; i < repeat; ++i) {
                pdfDoc.importPage(srcPage);
            }
            pdfDoc.save(add);
        }
    }

    public static void addPdfPages(File src, File add) throws IOException {
        try (PDDocument pdfDoc = new PDDocument();
             PDDocument addDoc = Loader.loadPDF((File)add);){
            for (int i = 0; i < addDoc.getNumberOfPages(); ++i) {
                PDPage addPage = addDoc.getPage(i);
                pdfDoc.importPage(addPage);
            }
            pdfDoc.save(src);
        }
    }

    public static void addPdfPages(File src, File add, int startPage, int endPage) throws IOException {
        try (PDDocument pdfDoc = new PDDocument();
             PDDocument addDoc = Loader.loadPDF((File)add);){
            if (startPage < 1 || startPage > addDoc.getNumberOfPages()) {
                throw new IndexOutOfBoundsException("startPage=" + startPage + ", NumberOfPages=" + addDoc.getNumberOfPages());
            }
            if (endPage < startPage || endPage > addDoc.getNumberOfPages()) {
                throw new IndexOutOfBoundsException("endPage=" + endPage + ", NumberOfPages=" + addDoc.getNumberOfPages());
            }
            for (int i = startPage - 1; i < endPage; ++i) {
                PDPage addPage = addDoc.getPage(i);
                pdfDoc.importPage(addPage);
            }
            pdfDoc.save(src);
        }
    }

    public static void emptyPdf(File file) throws IOException {
        try (PDDocument pdfDoc = new PDDocument();){
            PDPage page = new PDPage();
            pdfDoc.addPage(page);
            try (PDPageContentStream contentStream = new PDPageContentStream(pdfDoc, page);){
                contentStream.beginText();
                contentStream.setFont((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), 10.0f);
                contentStream.newLineAtOffset(25.0f, 25.0f);
                contentStream.showText(" ");
                contentStream.endText();
            }
            pdfDoc.save(file);
            log.info((Object)("PDF vac\u00edo creado en: " + file.getAbsolutePath()));
        }
    }

    public static int getPageCount(File pdf) throws IOException {
        if (!pdf.getName().endsWith(".pdf")) {
            return 0;
        }
        if (pdf.length() < 20000L) {
            return PdfUtils.getPdfPages(pdf);
        }
        byte[] buf1 = new byte[1024];
        int r = 0;
        Object last = "";
        String current = "";
        int count = 0;
        try (FileInputStream in = new FileInputStream(pdf);){
            while ((r = in.read(buf1)) > 0) {
                if (r < buf1.length) {
                    byte[] temp = new byte[r];
                    System.arraycopy(buf1, 0, temp, 0, r);
                    current = new String(temp);
                } else {
                    current = new String(buf1);
                }
                String str = "Type/Page/";
                Object c = (String)last + current;
                int ind = ((String)c).indexOf(str);
                if (ind != -1) {
                    do {
                        ++count;
                    } while ((ind = ((String)(c = ((String)c).substring(ind + str.length()))).indexOf(str)) != -1);
                    last = c;
                    continue;
                }
                last = "";
            }
        }
        if (count == 0) {
            return PdfUtils.getPdfPages(pdf);
        }
        return count;
    }

    public static int getPdfPages(File pdf) throws IOException {
        try (PDDocument pdfDoc = Loader.loadPDF((File)pdf);){
            int n = pdfDoc.getNumberOfPages();
            return n;
        }
    }

    public static PDDocument readPdfDocument(File pdf) throws IOException {
        return Loader.loadPDF((File)pdf);
    }

    public static void encryptPdf(String src, String dest, String userPass, String ownerPass) throws IOException {
        log.info((Object)("encryptPdf(" + src + "," + dest + ")"));
        try (PDDocument pdfDoc = Loader.loadPDF((File)new File(src));){
            AccessPermission ap = new AccessPermission();
            ap.setCanPrint(true);
            StandardProtectionPolicy spp = new StandardProtectionPolicy(ownerPass, userPass, ap);
            spp.setEncryptionKeyLength(128);
            spp.setPermissions(ap);
            pdfDoc.protect((ProtectionPolicy)spp);
            pdfDoc.save(dest);
            log.info((Object)"PDF encriptado con \u00e9xito.");
        }
    }

    public static List<File> getSignedAttachments(File pdf, File dir) throws IOException {
        try (PDDocument pdfDoc = Loader.loadPDF((File)pdf);){
            List<File> list = PdfUtils.getSignedAttachments(pdfDoc, dir);
            return list;
        }
    }

    public static List<File> getSignedAttachments(PDDocument pdfDoc, File dir) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        if (dir == null) {
            dir = new File("attachments");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (PDPage page : pdfDoc.getPages()) {
            for (Object annotation : page.getAnnotations()) {
                PDAnnotationFileAttachment fileAttachment;
                PDFileSpecification pDFileSpecification;
                if (!(annotation instanceof PDAnnotationFileAttachment) || !((pDFileSpecification = (fileAttachment = (PDAnnotationFileAttachment)annotation).getFile()) instanceof PDComplexFileSpecification)) continue;
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)pDFileSpecification;
                String fileName = fileSpec.getFile();
                File signTemp = new File(dir, new File(fileName).getName());
                FileUtils.writeByteArrayToFile((File)signTemp, (byte[])fileSpec.getEmbeddedFile().toByteArray());
                results.add(signTemp);
            }
        }
        return results;
    }
}

