/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.token.impl;

import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.List;

public class SignatureTokenSerialAlias
extends AbstractSignatureTokenConnection
implements SignatureToken {
    private static final Logger log = Logger.getLogger(SignatureTokenSerialAlias.class);
    protected ANFSignatureToken token;
    protected String serial;
    protected String alias;
    private char[] pin;

    public SignatureTokenSerialAlias(ANFSignatureToken manager, String serial, String alias, char[] pin) {
        this(manager, serial, alias);
        this.pin = pin;
    }

    public SignatureTokenSerialAlias(ANFSignatureToken manager, String serial, String alias) {
        this.token = manager;
        this.serial = serial;
        this.alias = alias;
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        log.info(new Object[]{"Signature algorithm : {}", javaSignatureAlgorithm});
        double t1 = System.nanoTime();
        try {
            byte[] signedData = this.pin != null ? this.token.signData(this.serial, this.alias, toBeSigned.getBytes(), signatureAlgorithm.getJCEId(), this.pin) : this.token.signData(this.serial, this.alias, toBeSigned.getBytes(), signatureAlgorithm.getJCEId());
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signedData);
            UtilsPki.verifyData((byte[])toBeSigned.getBytes(), (byte[])signedData, (PublicKey)this.token.getSignCertificate(this.serial, this.alias).getPublicKey(), (String)signatureAlgorithm.getJCEId(), (Provider)Security.getProvider("BC"));
            SignatureValue signatureValue = value;
            return signatureValue;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            log.info((Object)("tokensign in " + ((double)System.nanoTime() - t1) / 1000000.0 + " ms"));
        }
    }

    protected Signature getSignatureInstance(String javaSignatureAlgorithm) {
        return this.token.getSignatureInstance(this.serial, javaSignatureAlgorithm);
    }

    public void close() {
    }

    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        throw new DSSException("ANF not implemented");
    }

    @Override
    public X509Certificate[] getSignCertificateChain() {
        return this.token.getSignCertificateChain(this.serial, this.alias);
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.token.typeName();
    }

    @Override
    public ANFSignatureToken getAnfToken() {
        return this.token;
    }
}

