/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.params.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.sign.exception.NoSigningCertFoundInChain;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.sign.cert.SignatureCertValidation;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.impl.DSSKeyInfo;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.sources.ANFTSPSource;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CertificateParamsImpl
implements CertificateParams {
    private EncryptionAlgorithm encryptionAlg = EncryptionAlgorithm.RSA;
    private SignatureToken signToken;
    private SignatureCertValidation signCertValidation;
    protected CertificateToken[] certChain;
    protected TSPSource tspSource;
    private DSSPrivateKeyEntry keyInfo;
    private List<CertificateToken> certificates;
    private CertificateToken signCert;

    public CertificateParamsImpl(SignatureToken signToken) {
        this.setToken(signToken);
    }

    public CertificateParamsImpl(X509Certificate[] certificateChain) {
        this.setCertificates(certificateChain);
    }

    @Override
    public void setToken(SignatureToken token) {
        this.signToken = token;
        X509Certificate[] certificateChain = this.signToken.getSignCertificateChain();
        this.setCertificates(certificateChain);
    }

    private void setCertificates(X509Certificate[] certificateChain) {
        if (certificateChain == null) {
            throw new ANFCertificateException("ERR_NULL_CHAIN");
        }
        if (certificateChain.length == 1) {
            certificateChain = CertUtils.buildChain((X509Certificate[])certificateChain);
        }
        this.certChain = new CertificateToken[certificateChain.length];
        for (int i = 0; i < this.certChain.length; ++i) {
            this.certChain[i] = new CertificateToken(certificateChain[i]);
        }
        int finalCert = CertUtils.getFinalCert((X509Certificate[])certificateChain);
        if (finalCert == -1) {
            throw new NoSigningCertFoundInChain();
        }
        this.signCert = new CertificateToken(certificateChain[finalCert]);
        this.certificates = new ArrayList<CertificateToken>(certificateChain.length);
        for (X509Certificate cert : certificateChain) {
            this.certificates.add(new CertificateToken(cert));
        }
        this.encryptionAlg = EncryptionAlgorithm.forKey((Key)this.signCert.getPublicKey());
        this.keyInfo = new DSSKeyInfo(this.signCert, this.certChain, this.encryptionAlg);
        this.tspSource = new ANFTSPSource(Confis.get().getTSUControl(), certificateChain);
    }

    @Override
    public DSSPrivateKeyEntry getKeyInfo() {
        return this.keyInfo;
    }

    @Override
    public SignatureToken getSignatureToken() {
        return this.signToken;
    }

    @Override
    public void setSignCertValidation(SignatureCertValidation validateSignCert) {
        this.signCertValidation = validateSignCert;
    }

    @Override
    public SignatureCertValidation getSignCertValidation() {
        return this.signCertValidation;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.certificates;
    }

    @Override
    public CertificateToken[] getCertChain() {
        return this.certChain;
    }

    @Override
    public TSPSource getTspSource() {
        return this.tspSource;
    }

    @Override
    public CertificateToken getSignCert() {
        return this.signCert;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }
}

