/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.FontInfo;
import com.anf.cryptotoken.sign.pades.params.FontStyle;
import com.anf.cryptotoken.sign.pades.params.ImageRectangle;
import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.params.TextRectangle;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.pades.visible.ImageAdjustment;
import com.anf.cryptotoken.sign.pades.visible.ImagePosition;
import com.anf.cryptotoken.sign.utils.HexToColor;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class VisibleParamsConfigurer {
    private static final List<String> fontsInSystem = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    private VisibleSignatureParams visibleParams;

    public VisibleParamsConfigurer(VisibleSignatureParams visibleParams) {
        this.visibleParams = visibleParams;
    }

    public VisibleSignatureParams build() {
        return this.visibleParams;
    }

    public VisibleParamsConfigurer setText(String text) {
        if (text != null) {
            this.visibleParams.setText(text);
        }
        return this;
    }

    public VisibleParamsConfigurer addTextBox(TextRectangle ... textBoxes) {
        if (textBoxes != null && textBoxes.length > 0) {
            for (TextRectangle textBox : textBoxes) {
                this.visibleParams.addTextBox(textBox);
            }
        }
        return this;
    }

    public VisibleParamsConfigurer addImageBox(ImageRectangle imageBox) {
        this.visibleParams.addImageBox(imageBox);
        return this;
    }

    public VisibleParamsConfigurer setColors(String borderColor, String backgroundColor) {
        if (borderColor != null && !borderColor.equalsIgnoreCase("")) {
            this.visibleParams.setBorderColor(HexToColor.getColor(borderColor));
        }
        if (backgroundColor != null && !backgroundColor.equalsIgnoreCase("")) {
            this.visibleParams.setBackgroundColor(HexToColor.getColor(backgroundColor));
        }
        return this;
    }

    public VisibleParamsConfigurer setFont(FontInfo font) {
        if (font != null) {
            String fontName = "";
            float fontSize = 14.0f;
            fontName = font.getName();
            if (fontName.equals("") || !fontsInSystem.contains(fontName)) {
                fontName = "Arial";
            }
            if (font.getSize() != 0.0f) {
                fontSize = font.getSize();
            }
            FontStyle fontStyle = font.getStyle();
            this.visibleParams.setFont(fontName, fontSize, fontStyle);
        }
        return this;
    }

    public VisibleParamsConfigurer setImage(File imageFile, ImagePosition imagePosition, ImageAdjustment imageAdjustment) throws IOException {
        if (imageFile != null) {
            this.visibleParams.addImageBox(new ImageRectangle(new Rectangle(0.0, 0.0, 100.0, 100.0), imageFile, imagePosition, imageAdjustment));
        }
        return this;
    }
}

