/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.PadesSignaturePosition;
import com.anf.cryptotoken.sign.pades.params.SignPosition;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfFreeSignPositionCalculator;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfPositionCalculator;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfSignPositionRotator;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfSignatureLocations;
import com.anf.cryptotoken.sign.pades.visible.builder.VisibleParamsConfigurer;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import java.io.File;
import java.io.IOException;

public class VisibleParamsBuilder {
    private static PdfPositionCalculator pdfPositionCalculator = new PdfPositionCalculator(new PdfSignatureLocations(), new PdfFreeSignPositionCalculator(), new PdfSignPositionRotator());

    public VisibleParamsConfigurer of(File signedFile, SignPosition position) throws IOException {
        return new VisibleParamsConfigurer(this.buildPositionParams(position, signedFile));
    }

    private VisibleSignatureParams buildPositionParams(SignPosition position, File fileToSignPath) throws IOException {
        VisualSignatureRotation rotation = null;
        if (position.getRotation() != null) {
            rotation = position.getRotation();
        }
        String positionType = "Pixels";
        if (position.getType() != null) {
            positionType = position.getType();
        }
        int pagina = 1;
        if (position.getPage() != null && (pagina = position.getPage().intValue()) <= 0) {
            pagina = 1;
        }
        PadesSignaturePosition pixelPos = pdfPositionCalculator.calculateFreePositionInPixels(fileToSignPath, pagina, position, positionType, rotation);
        VisibleSignatureParams visibleParams = new VisibleSignatureParams(pagina, (float)pixelPos.getX(), (float)pixelPos.getY(), (int)pixelPos.getWidth(), (int)pixelPos.getHeight());
        if (rotation != null) {
            visibleParams.setRotation(rotation);
        }
        return visibleParams;
    }
}

