/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.PadesSignaturePosition;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PdfSignatureLocations {
    public List<PadesSignaturePosition> getRectanglesOfVisibleSignaturesInPades(PDRectangle pageSize, List<PDField> fields, int page) {
        LinkedList<PadesSignaturePosition> signaturesPosition = new LinkedList<PadesSignaturePosition>();
        double pageW = pageSize.getWidth();
        double pageH = pageSize.getHeight();
        for (PDField field : fields) {
            PDSignatureField sigField;
            PDRectangle rectangle;
            float[] pos;
            if (!(field instanceof PDSignatureField) || (int)(pos = (rectangle = ((PDAnnotationWidget)(sigField = (PDSignatureField)field).getWidgets().get(0)).getRectangle()).getCOSArray().toFloatArray())[0] != page) continue;
            double left = pos[1];
            double bottom = pos[2];
            double right = pos[3];
            double top = pos[4];
            double width = right - left;
            double height = top - bottom;
            top = (double)pageSize.getHeight() - top;
            double x = left * 100.0 / pageW;
            double y = top * 100.0 / pageH;
            double widthInt = width * 100.0 / pageW;
            double heightInt = height * 100.0 / pageH;
            if (width == 0.0 || height == 0.0) continue;
            PadesSignaturePosition position = new PadesSignaturePosition(x, y, widthInt, heightInt);
            signaturesPosition.add(position);
        }
        return signaturesPosition;
    }
}

