/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.PadesSignaturePosition;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;

public class PdfSignPositionRotator {
    public PadesSignaturePosition rotate(PadesSignaturePosition percentPosition, VisualSignatureRotation rotation) {
        PadesSignaturePosition rotated = new PadesSignaturePosition(percentPosition.getX(), percentPosition.getY(), percentPosition.getWidth(), percentPosition.getHeight());
        if (rotation == null) {
            return rotated;
        }
        switch (rotation) {
            case ROTATE_90: {
                double tmp = rotated.getX();
                rotated.setX(100.0 - rotated.getY() - rotated.getHeight());
                rotated.setY(tmp);
                tmp = rotated.getWidth();
                rotated.setWidth(rotated.getHeight());
                rotated.setHeight(tmp);
                break;
            }
            case ROTATE_270: {
                double tmp = rotated.getX();
                rotated.setX(rotated.getY());
                rotated.setY(100.0 - tmp - rotated.getWidth());
                tmp = rotated.getWidth();
                rotated.setWidth(rotated.getHeight());
                rotated.setHeight(tmp);
                break;
            }
            case ROTATE_180: {
                rotated.setX(100.0 - rotated.getX() - rotated.getWidth());
                rotated.setY(100.0 - rotated.getY() - rotated.getHeight());
                break;
            }
        }
        return rotated;
    }

    public PadesSignaturePosition rotateBack(PadesSignaturePosition percentPosition, VisualSignatureRotation rotation) {
        if (rotation == null) {
            return percentPosition;
        }
        switch (rotation) {
            case ROTATE_90: {
                rotation = VisualSignatureRotation.ROTATE_270;
                break;
            }
            case ROTATE_180: {
                rotation = VisualSignatureRotation.ROTATE_180;
                break;
            }
            case ROTATE_270: {
                rotation = VisualSignatureRotation.ROTATE_90;
                break;
            }
            default: {
                rotation = null;
            }
        }
        return this.rotate(percentPosition, rotation);
    }
}

