/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.sign.PadesSignature;
import com.anf.cryptotoken.sign.cert.SignatureCertValidation;
import com.anf.cryptotoken.sign.factory.SignatureFactory;
import com.anf.cryptotoken.sign.pades.params.PadesSignatureParams;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.CertificateParamsFactory;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.token.SignatureTokenFactory;
import com.anf.cryptotoken.tkmanager.utils.PfxGenerator;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class VisibleSignaturePreviewGenerator {
    private File tempPfx;
    private String pin;
    private PadesSignature padesSignature;
    private CertificateParams certificateParams;

    private VisibleSignaturePreviewGenerator() {
        SignatureFactory builder = new SignatureFactory();
        this.padesSignature = builder.padesSignature();
        this.padesSignature.setValidateCertOCSPStatus(false);
        this.padesSignature.setValidateIfCertIsQualified(false);
    }

    public VisibleSignaturePreviewGenerator(PfxGenerator pfxGenerator, String pin) throws Exception {
        this();
        KeyPair keyPair = pfxGenerator.generateKeyPair();
        X509Certificate cert = pfxGenerator.generateCert(keyPair);
        this.tempPfx = pfxGenerator.generateTempPfx(keyPair.getPrivate(), cert, pin);
        this.pin = pin;
        this.loadToken();
    }

    public VisibleSignaturePreviewGenerator(File tempPfx, String pin) {
        this();
        this.tempPfx = tempPfx;
        this.pin = pin;
        this.loadToken();
    }

    private void loadToken() {
        this.tempPfx.deleteOnExit();
        ANFCryptoToken server = ANFControl.get().getInstancePFX(this.tempPfx, this.pin.toCharArray());
        String serial = server.getSerialNumberToken(0);
        Enumeration aliases = server.getAlias(serial);
        SignatureToken token = SignatureTokenFactory.buildFrom((ANFSignatureToken)server, serial, (String)aliases.nextElement());
        this.certificateParams = CertificateParamsFactory.createCertificateParams(token);
        SignatureCertValidation validateSignCert = new SignatureCertValidation(null, null, new X509Certificate[]{this.certificateParams.getSignCert().getCertificate()}, false, false){

            @Override
            public void validateSignCert() {
            }

            @Override
            public X509Certificate getCertificate() {
                return VisibleSignaturePreviewGenerator.this.certificateParams.getSignCert().getCertificate();
            }
        };
        this.certificateParams.setSignCertValidation(validateSignCert);
    }

    public File createEmptyPdf() {
        try {
            File tempPdf = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString() + ".pdf");
            try (PDDocument pdfDocument = new PDDocument();){
                pdfDocument.save(tempPdf);
            }
            return tempPdf;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating empty PDF", e);
        }
    }

    private void sign(File src, File dest, VisibleSignatureParams visible) throws Exception {
        PadesSignatureParams params = new PadesSignatureParams(this.certificateParams, DigestAlgorithm.SHA256, SignatureLevel.PAdES_BASELINE_B, SignaturePackaging.ENVELOPING, "reason", "loc", visible);
        params.getPadesText().setLocale(new Locale("es"));
        this.padesSignature.sign(params, src, dest);
    }

    private BufferedImage getVisibleSignatureImage(File dest, VisibleSignatureParams visible) throws IOException {
        PDDocument document = Loader.loadPDF((File)dest);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        int page = 0;
        int pdi = 300;
        BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 300.0f, ImageType.ARGB);
        SignatureFieldParameters field = visible.getImageParameters().getFieldParameters();
        int margin = 2;
        BufferedImage rect = bim.getSubimage(Math.max(0, (int)DPIUtils.computeProperSize((float)field.getOriginX(), (float)pdi) - margin), Math.max(0, (int)DPIUtils.computeProperSize((float)field.getOriginY(), (float)pdi) - margin), (int)DPIUtils.computeProperSize((float)field.getWidth(), (float)pdi) + margin * 2, (int)DPIUtils.computeProperSize((float)field.getHeight(), (float)pdi) + margin * 2);
        document.close();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage generatePreview(File pdf, VisibleSignatureParams visible) throws Exception {
        File signed = new File(pdf.getParentFile(), FilenameUtils.getBaseName((String)pdf.getName()) + "-signed.pdf");
        try {
            this.sign(pdf, signed, visible);
            BufferedImage bufferedImage = this.getVisibleSignatureImage(signed, visible);
            return bufferedImage;
        }
        finally {
            FileUtils.deleteQuietly((File)signed);
        }
    }

    public void exportImage(BufferedImage image, File dest) throws IOException {
        ImageIO.write((RenderedImage)image, "png", dest);
    }
}

