/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.visible.PdfSignatureField;
import eu.europa.esig.dss.model.DSSException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PdfSignatureFieldsDetector {
    private PdfSignatureFieldsDetector() {
    }

    public static List<PdfSignatureField> detectSignatureFields(File src) {
        ArrayList<PdfSignatureField> fields = new ArrayList<PdfSignatureField>();
        try (PDDocument pdfDoc = Loader.loadPDF((File)src);){
            List signatureFields = pdfDoc.getSignatureFields();
            for (PDSignatureField pdSignatureField : signatureFields) {
                PDAnnotationWidget mainWidget;
                PDPage page;
                List widgets = pdSignatureField.getWidgets();
                PDSignature signature = pdSignatureField.getSignature();
                PdfSignatureField field = new PdfSignatureField();
                field.setSigned(signature != null);
                field.setFieldId(pdSignatureField.getPartialName());
                if (!widgets.isEmpty() && (page = (mainWidget = (PDAnnotationWidget)widgets.get(0)).getPage()) != null) {
                    field.setPage(pdfDoc.getPages().indexOf(page) + 1);
                    PDRectangle rect = mainWidget.getRectangle();
                    field.setRect(new Rectangle(rect.getLowerLeftX(), page.getBBox().getHeight() - rect.getLowerLeftY() - rect.getHeight(), rect.getWidth(), rect.getHeight()));
                }
                fields.add(field);
            }
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(e.getMessage());
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to retrieve signature fields. Reason : %s", e.getMessage()), (Throwable)e);
        }
        return fields;
    }
}

