/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.sign.pades.params.Rectangle;
import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiLineTextDrawer {
    private static final Logger log = LogManager.getLogger(MultiLineTextDrawer.class);

    public static void draw(Graphics g, String text, Rectangle rect, Font font, Color color, SignerTextHorizontalAlignment horizontalAlignment, SignerTextVerticalAlignment verticalAlignment) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(color);
        g2d.setFont(font);
        int width = (int)rect.getWidth();
        int height = (int)rect.getHeight();
        String[] textLines = text.split("\n");
        ArrayList<TextLayout> lines = new ArrayList<TextLayout>();
        float maxDescent = 0.0f;
        float y = 0.0f;
        float textHeight = 0.0f;
        for (String textLine : textLines) {
            if ((textLine = textLine.trim()).isBlank()) continue;
            FontRenderContext frc = g2d.getFontRenderContext();
            AttributedString as = new AttributedString(textLine);
            as.addAttribute(TextAttribute.FONT, font);
            AttributedCharacterIterator aci = as.getIterator();
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < textLine.length()) {
                TextLayout layout = lbm.nextLayout(width);
                lines.add(layout);
                log.debug("layout " + layout.getAscent() + " " + layout.getDescent() + " " + layout.getBounds().getHeight() + " " + layout.getCharacterCount());
                maxDescent = Math.max(maxDescent, layout.getDescent());
                textHeight = (float)((double)textHeight + (layout.getBounds().getHeight() + (double)layout.getDescent()));
            }
        }
        log.info("drawing text {}", (Object)text);
        float dy = MultiLineTextDrawer.getVerticalOffset(textHeight, height, verticalAlignment);
        for (TextLayout layout : lines) {
            float dx = MultiLineTextDrawer.getHorizontalOffset(layout, width, horizontalAlignment);
            layout.draw(g2d, (float)rect.getX() + dx, (float)rect.getY() + dy + y + layout.getAscent());
            g2d.setColor(Color.yellow);
            g2d.setColor(Color.black);
            y = (float)((double)y + (layout.getBounds().getHeight() + (double)layout.getDescent()));
        }
    }

    private static float getHorizontalOffset(TextLayout layout, int width, SignerTextHorizontalAlignment horizontalAlignment) {
        switch (horizontalAlignment) {
            case CENTER: {
                return ((float)width - layout.getAdvance()) / 2.0f;
            }
            case RIGHT: {
                return (float)width - layout.getAdvance();
            }
        }
        return 0.0f;
    }

    private static float getVerticalOffset(float textHeight, int height, SignerTextVerticalAlignment verticalAlignment) {
        switch (verticalAlignment) {
            case MIDDLE: {
                return (float)height / 2.0f - textHeight / 2.0f;
            }
            case BOTTOM: {
                return (float)height - textHeight;
            }
        }
        return 0.0f;
    }
}

