/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.pades.params.FontStyle;
import com.anf.cryptotoken.sign.pades.params.ImageRectangle;
import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.params.TextRectangle;
import com.anf.cryptotoken.sign.pades.params.TextWrap;
import com.anf.cryptotoken.sign.pades.visible.MultiLineTextDrawer;
import com.anf.cryptotoken.sign.pades.visible.StringDrawerUtils;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.DSSJavaFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultImageDrawerUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ImageBuilder {
    private static final Logger log = Logger.getLogger(ImageBuilder.class);
    public static final DSSJavaFont defaultFont = new DSSJavaFont("SansSerif", FontStyle.Plain.ordinal(), 40);
    public final Color transparent;
    private SignatureImageParameters imageParameters;
    private SignatureImageTextParameters textParameters;
    private Color borderColor;
    private List<TextRectangle> textBoxes;
    private List<ImageRectangle> imageBoxes;
    private float resolutionFactor;

    public ImageBuilder(SignatureImageParameters imageParameters, SignatureImageTextParameters textParameters) {
        this.borderColor = this.transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.textBoxes = new ArrayList<TextRectangle>();
        this.imageBoxes = new ArrayList<ImageRectangle>();
        this.resolutionFactor = 20.0f;
        this.imageParameters = imageParameters;
        this.textParameters = textParameters;
        textParameters.setSignerTextHorizontalAlignment(SignerTextHorizontalAlignment.LEFT);
        textParameters.setFont((DSSFont)defaultFont);
        textParameters.setBackgroundColor(this.transparent);
        imageParameters.setBackgroundColor(this.transparent);
        textParameters.setTextColor(Color.BLACK);
    }

    public void setText(String text) {
        log.info((Object)("pades image text: " + text));
        this.textParameters.setText(text);
    }

    public InMemoryDocument buildImage() {
        double t1 = System.nanoTime();
        float width = this.imageParameters.getFieldParameters().getWidth();
        float height = this.imageParameters.getFieldParameters().getHeight();
        BufferedImage img = new BufferedImage((int)(width * this.resolutionFactor), (int)(height * this.resolutionFactor), 2);
        Graphics2D graphics = img.createGraphics();
        DefaultImageDrawerUtils.initRendering((Graphics2D)graphics);
        this.drawBackground(img, graphics);
        if (!this.imageBoxes.isEmpty()) {
            for (ImageRectangle imageBox : this.imageBoxes) {
                this.drawImage(graphics, new ImageRectangle(this.scaleRectResolution(this.transformPercentToPixel(imageBox, width, height)), imageBox.getImage(), imageBox.getPosition(), imageBox.getAdjustment()));
            }
        }
        if (this.textBoxes.isEmpty()) {
            this.textBoxes.add(new TextRectangle(new Rectangle(0.0, 0.0, 100.0, 100.0)));
        }
        for (TextRectangle textBox : this.textBoxes) {
            TextRectangle textRect = new TextRectangle(this.scaleRectResolution(this.transformPercentToPixel(textBox, width, height)), textBox);
            SignatureImageTextParameters textRectParams = textRect.buildParams(this.textParameters);
            this.drawText(graphics, textRectParams, textRect);
        }
        this.drawBorders(img, graphics);
        byte[] content = this.imageToByteArray(img);
        String name = UUID.randomUUID() + ".png";
        InMemoryDocument document = new InMemoryDocument(content, name, (MimeType)MimeTypeEnum.PNG);
        this.saveTempImage(content);
        log.info((Object)("image built in " + ((double)System.nanoTime() - t1) / 1000000.0 + " ms"));
        return document;
    }

    private void saveTempImage(byte[] content) {
        if (System.getProperty("pades.temp.image") == null && System.getenv("pades.temp.image") == null) {
            return;
        }
        try {
            File imgFile = new File(Files.temp, "pades-image-" + UUID.randomUUID().toString() + ".png");
            FileUtils.writeByteArrayToFile((File)imgFile, (byte[])content);
            log.debug((Object)imgFile.getCanonicalPath());
        }
        catch (IOException e) {
            log.error((Object)"error", (Throwable)e);
        }
    }

    private Rectangle transformPercentToPixel(Rectangle box, float width, float height) {
        if (box == null) {
            return new Rectangle(0.0, 0.0, width, height);
        }
        Rectangle transformed = new Rectangle(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        if (transformed.getWidth() == 0.0) {
            transformed.setWidth(width);
        } else {
            transformed.setWidth((double)width * transformed.getWidth() / 100.0);
        }
        if (transformed.getHeight() == 0.0) {
            transformed.setHeight(height);
        } else {
            transformed.setHeight((double)height * transformed.getHeight() / 100.0);
        }
        transformed.setX((double)width * box.getX() / 100.0);
        transformed.setY((double)height * box.getY() / 100.0);
        return transformed;
    }

    private Rectangle scaleRectResolution(Rectangle box) {
        return new Rectangle(box.getX() * (double)this.resolutionFactor, box.getY() * (double)this.resolutionFactor, box.getWidth() * (double)this.resolutionFactor, box.getHeight() * (double)this.resolutionFactor);
    }

    private void drawBorders(BufferedImage img, Graphics2D graphics) {
        if (this.borderColor != null) {
            graphics.setColor(this.borderColor);
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(new Rectangle2D.Double(1.0, 1.0, (double)img.getWidth() - 3.0, (double)img.getHeight() - 3.0));
            graphics.setStroke(stroke);
        }
    }

    private void drawBackground(BufferedImage img, Graphics2D graphics) {
        if (this.textParameters.getBackgroundColor() == null) {
            graphics.setColor(Color.WHITE);
        } else {
            graphics.setColor(this.textParameters.getBackgroundColor());
        }
        graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
    }

    private void drawImage(Graphics2D graphics, ImageRectangle rect) {
        BufferedImage buffImage = rect.getBuffImage();
        if (buffImage != null) {
            double x = 0.0;
            double y = 0.0;
            double imageWidth = buffImage.getWidth();
            double imageHeight = buffImage.getHeight();
            double rectWidth = rect.getWidth();
            double rectHeght = rect.getHeight();
            if (imageWidth > rectWidth) {
                imageHeight = (int)(imageHeight * (rectWidth / imageWidth));
                imageWidth = rectWidth;
            }
            if (imageHeight > rectHeght) {
                imageWidth = (int)(imageWidth * (rectHeght / imageHeight));
                imageHeight = rectHeght;
            }
            switch (rect.getAdjustment()) {
                case ADJUST: {
                    if (rectWidth > imageWidth && rectWidth / imageWidth * imageHeight <= rectHeght) {
                        imageHeight = (int)(rectWidth / imageWidth * imageHeight);
                        imageWidth = rectWidth;
                        break;
                    }
                    if (!(rectHeght > imageHeight) || !(rectHeght / imageHeight * imageWidth <= rectWidth)) break;
                    imageWidth = (int)(rectHeght / imageHeight * imageWidth);
                    imageHeight = rectHeght;
                    break;
                }
                case EXPAND: {
                    imageHeight = rectHeght;
                    imageWidth = rectWidth;
                    break;
                }
            }
            switch (rect.getPosition()) {
                case TOP_LEFT: {
                    y = 0.0;
                    x = 0.0;
                    break;
                }
                case TOP: {
                    x = rectWidth / 2.0 - imageWidth / 2.0;
                    y = 0.0;
                    break;
                }
                case TOP_RIGHT: {
                    x = rectWidth - imageWidth;
                    y = 0.0;
                    break;
                }
                case CENTER_LEFT: {
                    x = 0.0;
                    y = rectHeght / 2.0 - imageHeight / 2.0;
                    break;
                }
                case CENTER: {
                    x = rectWidth / 2.0 - imageWidth / 2.0;
                    y = rectHeght / 2.0 - imageHeight / 2.0;
                    break;
                }
                case CENTER_RIGHT: {
                    x = rectWidth - imageWidth;
                    y = rectHeght / 2.0 - imageHeight / 2.0;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = 0.0;
                    y = rectHeght - imageHeight;
                    break;
                }
                case BOTTOM: {
                    x = rectWidth / 2.0 - imageWidth / 2.0;
                    y = rectHeght - imageHeight;
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = rectWidth - imageWidth;
                    y = rectHeght - imageHeight;
                    break;
                }
            }
            graphics.drawImage(buffImage, (int)(rect.getX() + x), (int)(rect.getY() + y), (int)imageWidth, (int)imageHeight, null);
        }
    }

    private byte[] imageToByteArray(BufferedImage img) {
        byte[] content = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)img, "png", (OutputStream)out);
            out.flush();
            content = out.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return content;
    }

    private void drawText(Graphics2D g, SignatureImageTextParameters textRectParams, TextRectangle textRect) {
        String text = textRectParams.getText();
        DSSFont textFont = textRectParams.getFont();
        if (textFont != null) {
            textFont.setSize(textFont.getSize() * this.resolutionFactor * 0.2f);
        }
        if (text == null) {
            log.debug((Object)"no drawing null text");
            return;
        }
        log.debug((Object)("drawing text: " + text));
        if (textRectParams.getTextColor() == null) {
            textRectParams.setTextColor(Color.black);
        }
        g.setColor(textRectParams.getTextColor());
        if (textRect.getWrap() == TextWrap.WRAP_WORD) {
            MultiLineTextDrawer.draw(g, text, textRect, textRectParams.getFont().getJavaFont(), textRectParams.getTextColor(), textRectParams.getSignerTextHorizontalAlignment(), textRectParams.getSignerTextVerticalAlignment());
        } else {
            this.drawText(g, text, textRectParams, textRect);
        }
    }

    private void drawText(Graphics2D g, String text, SignatureImageTextParameters textRectParams, TextRectangle textRect) {
        String[] lines = text.split("\n");
        g.setFont(textRectParams.getFont().getJavaFont());
        FontMetrics fontMetrics = g.getFontMetrics();
        List<String> linesList = textRect.getWrap() == TextWrap.WRAP_CHAR ? StringDrawerUtils.wrap(text, fontMetrics, (int)textRect.getWidth()) : Arrays.asList(lines);
        int lineHeight = fontMetrics.getHeight();
        float y = (float)(textRect.getY() + (double)fontMetrics.getMaxAscent() + (double)textRectParams.getPadding());
        for (String line : linesList) {
            float x = (float)(textRect.getX() + (double)textRectParams.getPadding());
            if (textRectParams.getSignerTextHorizontalAlignment() != null) {
                switch (textRectParams.getSignerTextHorizontalAlignment()) {
                    case RIGHT: {
                        x = (float)textRect.getWidth() - (float)fontMetrics.stringWidth(line) - x;
                        break;
                    }
                    case CENTER: {
                        x = (float)(textRect.getWidth() - (double)fontMetrics.stringWidth(line)) / 2.0f;
                        break;
                    }
                }
            }
            g.drawString(line, x, y);
            y += (float)lineHeight;
        }
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public List<TextRectangle> getTextBoxes() {
        return this.textBoxes;
    }

    public List<ImageRectangle> getImageBoxes() {
        return this.imageBoxes;
    }

    public void addTextBox(TextRectangle textBox) {
        if (textBox != null) {
            this.textBoxes.add(textBox);
        }
    }

    public void addImageBox(ImageRectangle imageBox) {
        if (imageBox != null) {
            this.imageBoxes.add(imageBox);
        }
    }
}

