/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class GradientExtensionHandler
extends DefaultExtensionHandler {
    GradientExtensionHandler() {
    }

    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext generatorCtx) {
        if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint linear = (LinearGradientPaint)paint;
            return this.getLinearGradientPaintDescriptor(linear, generatorCtx);
        }
        if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint radial = (RadialGradientPaint)paint;
            return this.getRadialGradientPaintDescriptor(radial, generatorCtx);
        }
        return super.handlePaint(paint, generatorCtx);
    }

    private SVGPaintDescriptor getRadialGradientPaintDescriptor(RadialGradientPaint paint, SVGGeneratorContext generatorCtx) {
        RadialGradientPaint gradient = paint;
        Element grad = generatorCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        String id = generatorCtx.getIDGenerator().generateID("gradient");
        grad.setAttributeNS(null, "id", id);
        Point2D centerPt = gradient.getCenterPoint();
        grad.setAttributeNS(null, "cx", String.valueOf(centerPt.getX()));
        grad.setAttributeNS(null, "cy", String.valueOf(centerPt.getY()));
        Point2D focusPt = gradient.getFocusPoint();
        grad.setAttributeNS(null, "fx", String.valueOf(focusPt.getX()));
        grad.setAttributeNS(null, "fy", String.valueOf(focusPt.getY()));
        grad.setAttributeNS(null, "r", String.valueOf(gradient.getRadius()));
        this.setMultipleGradientPaintAttributes(generatorCtx, (MultipleGradientPaint)gradient, grad);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", grad);
    }

    private SVGPaintDescriptor getLinearGradientPaintDescriptor(LinearGradientPaint paint, SVGGeneratorContext generatorCtx) {
        LinearGradientPaint gradient = paint;
        String id = generatorCtx.getIDGenerator().generateID("gradient");
        Document doc = generatorCtx.getDOMFactory();
        Element grad = doc.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        grad.setAttributeNS(null, "id", id);
        Point2D pt = gradient.getStartPoint();
        grad.setAttributeNS(null, "x1", String.valueOf(pt.getX()));
        grad.setAttributeNS(null, "y1", String.valueOf(pt.getY()));
        pt = gradient.getEndPoint();
        grad.setAttributeNS(null, "x2", String.valueOf(pt.getX()));
        grad.setAttributeNS(null, "y2", String.valueOf(pt.getY()));
        this.setMultipleGradientPaintAttributes(generatorCtx, (MultipleGradientPaint)gradient, grad);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", grad);
    }

    private void setMultipleGradientPaintAttributes(SVGGeneratorContext generatorCtx, MultipleGradientPaint gradient, Element grad) {
        if (gradient.getCycleMethod().equals(MultipleGradientPaint.REFLECT)) {
            grad.setAttributeNS(null, "spreadMethod", "reflect");
        } else if (gradient.getCycleMethod().equals(MultipleGradientPaint.REPEAT)) {
            grad.setAttributeNS(null, "spreadMethod", "repeat");
        }
        if (gradient.getColorSpace().equals(MultipleGradientPaint.LINEAR_RGB)) {
            grad.setAttributeNS(null, "color-interpolation", "linearRGB");
        } else if (gradient.getColorSpace().equals(MultipleGradientPaint.SRGB)) {
            grad.setAttributeNS(null, "color-interpolation", "sRGB");
        }
        Color[] colors = gradient.getColors();
        float[] fracs = gradient.getFractions();
        for (int i = 0; i < colors.length; ++i) {
            Element stop = generatorCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "stop");
            SVGPaintDescriptor pd = SVGColor.toSVG((Color)colors[i], (SVGGeneratorContext)generatorCtx);
            stop.setAttribute("offset", (int)(fracs[i] * 100.0f) + "%");
            stop.setAttribute("stop-color", pd.getPaintValue());
            if (colors[i].getAlpha() != 255) {
                stop.setAttribute("stop-opacity", pd.getOpacityValue());
            }
            grad.appendChild(stop);
        }
    }
}

