/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.sign.pades.params.FontInfo;
import com.anf.cryptotoken.sign.pades.params.FontStyle;
import com.anf.cryptotoken.sign.pades.params.ImageRectangle;
import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.params.TextRectangle;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.utils.HexToColor;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.DSSFileFont;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.DSSJavaFont;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.AbstractPdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxNativeFont;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultImageDrawerUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxDSSFontMetrics;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxFontMapper;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;

public class CustomNativePdfBoxVisibleSignatureDrawer
extends AbstractPdfBoxSignatureDrawer {
    private static final Logger log = LogManager.getLogger(CustomNativePdfBoxVisibleSignatureDrawer.class);
    private PDFont pdFont;
    private DSSResourcesHandlerBuilder resourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;
    private VisibleSignatureParams params;

    public CustomNativePdfBoxVisibleSignatureDrawer(VisibleSignatureParams params) {
        this.params = params;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    public void init(SignatureImageParameters parameters, PDDocument document, SignatureOptions signatureOptions) throws IOException {
        super.init(parameters, document, signatureOptions);
        if (!parameters.getTextParameters().isEmpty()) {
            this.pdFont = this.initFont();
        }
    }

    private PDFont initFont() throws IOException {
        DSSFont dssFont = this.parameters.getTextParameters().getFont();
        return this.getPdfFont(dssFont);
    }

    private PDFont getPdfFont(DSSFont dssFont) throws IOException {
        if (dssFont instanceof PdfBoxNativeFont) {
            PdfBoxNativeFont nativeFont = (PdfBoxNativeFont)dssFont;
            return nativeFont.getFont();
        }
        if (dssFont instanceof DSSFileFont) {
            DSSFileFont fileFont = (DSSFileFont)dssFont;
            try (InputStream is = fileFont.getInputStream();){
                PDType0Font pDType0Font = PDType0Font.load((PDDocument)this.document, (InputStream)is, (boolean)fileFont.isEmbedFontSubset());
                return pDType0Font;
            }
        }
        return PdfBoxFontMapper.getPDFont((Font)dssFont.getJavaFont());
    }

    protected DSSFontMetrics getDSSFontMetrics() {
        return new PdfBoxDSSFontMetrics(this.pdFont);
    }

    public void draw() throws IOException {
        try (DSSResourcesHandler resourcesHandler = this.resourcesHandlerBuilder.createResourcesHandler();
             OutputStream os = resourcesHandler.createOutputStream();
             PDDocument doc = new PDDocument();){
            int pageNumber = this.parameters.getFieldParameters().getPage() - 1;
            PDPage originalPage = this.document.getPage(pageNumber);
            SignatureFieldDimensionAndPosition dimensionAndPosition = this.buildSignatureFieldBox();
            PDPage page = new PDPage(originalPage.getMediaBox());
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            PDRectangle rectangle = this.getPdRectangle(dimensionAndPosition, page);
            widget.setRectangle(rectangle);
            PDAppearanceDictionary appearance = PdfBoxUtils.createSignatureAppearanceDictionary((PDDocument)doc, (PDRectangle)rectangle);
            widget.setAppearance(appearance);
            PDAppearanceStream appearanceStream = appearance.getNormalAppearance().getAppearanceStream();
            try (PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);){
                Color borderColor;
                Color backgroundColor = this.params.getBackgroundColor();
                if (backgroundColor == null) {
                    backgroundColor = new Color(0, 0, 0, 0);
                }
                if ((borderColor = this.params.getBorderColor()) == null) {
                    borderColor = new Color(0, 0, 0, 0);
                }
                this.drawBackgroundAndBorder(cs, backgroundColor, borderColor, new PDRectangle(0.0f, 0.0f, dimensionAndPosition.getBoxWidth(), dimensionAndPosition.getBoxHeight()));
                this.rotateSignature(cs, rectangle, dimensionAndPosition);
                this.drawImages(this.params.getImageBoxes(), cs, doc, rectangle, dimensionAndPosition);
                List<TextRectangle> textBoxes = this.params.getTextBoxes();
                if (textBoxes.isEmpty() && this.parameters.getTextParameters() != null && this.parameters.getTextParameters().getText() != null && !this.parameters.getTextParameters().getText().isBlank()) {
                    TextRectangle rect = new TextRectangle(0.0, 0.0, 100.0, 100.0);
                    rect.setText(this.parameters.getTextParameters().getText());
                    rect.setFont(new FontInfo("SansSerif", 8.0f, FontStyle.Plain));
                    textBoxes.add(rect);
                }
                for (TextRectangle textBox : textBoxes) {
                    SignerTextVerticalAlignment verticalAlignment;
                    SignerTextHorizontalAlignment alignment;
                    SignatureFieldDimensionAndPosition textBoxDimension = this.buildTextBox(dimensionAndPosition, textBox);
                    if (textBox.getText() == null) {
                        textBox.setText(this.parameters.getTextParameters().getText());
                    }
                    textBoxDimension.setText(textBox.getText());
                    float fontSize = -1.0f;
                    DSSFont font = this.parameters.getTextParameters().getFont();
                    if (textBox.getFont() != null) {
                        font = new DSSJavaFont(textBox.getFont().getName(), textBox.getFont().getStyle().ordinal(), (int)textBox.getFont().getSize());
                        fontSize = textBox.getFont().getSize();
                        font.setSize(fontSize);
                    }
                    if (fontSize == -1.0f && font != null) {
                        fontSize = font.getSize();
                    }
                    textBoxDimension.setTextSize(fontSize);
                    Color textColor = null;
                    if (textBox.getTextColor() != null) {
                        textColor = HexToColor.getColor(textBox.getTextColor());
                    }
                    if (textColor == null && this.parameters.getTextParameters().getTextColor() != null) {
                        textColor = this.parameters.getTextParameters().getTextColor();
                    }
                    if (textColor == null) {
                        textColor = Color.black;
                    }
                    if (textColor.getAlpha() == 0) {
                        log.warn("transparent text color: {}", (Object)textBox.getText());
                    }
                    if ((alignment = textBox.getHorizontalAlignment()) == null) {
                        alignment = textBox.getAlignment();
                    }
                    if (alignment == null) {
                        alignment = this.parameters.getTextParameters().getSignerTextHorizontalAlignment();
                    }
                    if (alignment == null) {
                        alignment = SignerTextHorizontalAlignment.LEFT;
                    }
                    if ((verticalAlignment = textBox.getVerticalAlignment()) == null) {
                        verticalAlignment = SignerTextVerticalAlignment.TOP;
                    }
                    this.setText(cs, dimensionAndPosition, textBoxDimension, font, textColor, alignment, verticalAlignment, this.parameters.getFieldParameters().getRotation(), textBox.getLineSpacing());
                }
            }
            doc.save(os);
            DSSDocument document = resourcesHandler.writeToDSSDocument();
            try (InputStream is = document.openStream();){
                this.signatureOptions.setVisualSignature(is);
                this.signatureOptions.setPage(pageNumber);
            }
        }
    }

    private void drawImages(List<ImageRectangle> imageBoxes, PDPageContentStream cs, PDDocument doc, PDRectangle rectangle, SignatureFieldDimensionAndPosition dimensionAndPosition) throws IOException {
        PdfBoxGraphics2D pdfBoxGraphics2D = null;
        VisualSignatureRotation rotation = this.parameters.getFieldParameters().getRotation();
        pdfBoxGraphics2D = rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270 ? new PdfBoxGraphics2D(doc, new PDRectangle(rectangle.getHeight(), rectangle.getWidth())) : new PdfBoxGraphics2D(doc, new PDRectangle(rectangle.getWidth(), rectangle.getHeight()));
        DefaultImageDrawerUtils.initRendering((Graphics2D)pdfBoxGraphics2D);
        List<ImageRectangle> imageNoSvg = this.params.getImageBoxes().stream().filter(i -> !i.isSvg()).toList();
        if (!imageNoSvg.isEmpty()) {
            BufferedImage image = this.params.getImageMergeTool().mergeImageBoxes(rotation, dimensionAndPosition, imageNoSvg, this.parameters.getDpi());
            if (rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270) {
                pdfBoxGraphics2D.drawImage((Image)image, 0, 0, (int)dimensionAndPosition.getBoxHeight(), (int)dimensionAndPosition.getBoxWidth(), null);
            } else {
                pdfBoxGraphics2D.drawImage((Image)image, 0, 0, (int)dimensionAndPosition.getBoxWidth(), (int)dimensionAndPosition.getBoxHeight(), null);
            }
        }
        imageBoxes.removeAll(imageNoSvg);
        for (ImageRectangle imageRectangle : imageBoxes) {
            SignatureFieldDimensionAndPosition rect = new SignatureFieldDimensionAndPosition();
            rect.setBoxWidth(rectangle.getWidth());
            rect.setBoxHeight(rectangle.getHeight());
            SignatureFieldDimensionAndPosition imageBox = this.params.getImageMergeTool().buildImageBox(rotation, rect, imageRectangle);
            float rectX = imageBox.getImageX();
            float rectY = imageBox.getImageY();
            float rectWidth = imageBox.getImageWidth();
            float rectHeight = imageBox.getImageHeight();
            Rectangle2D imageSize = imageRectangle.imageSize();
            double scaleX = (double)rectWidth / imageSize.getWidth();
            double scaleY = (double)rectHeight / imageSize.getHeight();
            AffineTransform transform = AffineTransform.getTranslateInstance(-imageSize.getX(), -imageSize.getY());
            transform.preConcatenate(AffineTransform.getTranslateInstance((double)rectX / scaleX, (double)rectY / scaleY - imageSize.getY()));
            transform.preConcatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            if (imageRectangle.isSvg()) {
                GraphicsNode svgGraphics = imageRectangle.getSvgGraphics();
                svgGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                svgGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                svgGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                svgGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                svgGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                svgGraphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                svgGraphics.setTransform(transform);
                svgGraphics.paint((Graphics2D)pdfBoxGraphics2D);
                continue;
            }
            pdfBoxGraphics2D.drawImage((Image)imageRectangle.getBuffImage(), transform, null);
        }
        pdfBoxGraphics2D.dispose();
        PDFormXObject xForm = pdfBoxGraphics2D.getXFormObject();
        cs.saveGraphicsState();
        this.setAlphaChannel(cs, 255.0f, 255.0f);
        cs.setStrokingColor(new Color(255, 255, 255, 255));
        cs.drawForm(xForm);
        cs.restoreGraphicsState();
    }

    private SignatureFieldDimensionAndPosition buildTextBox(SignatureFieldDimensionAndPosition dimensionAndPosition, Rectangle textBox) {
        SignatureFieldDimensionAndPosition textBoxDimension = new SignatureFieldDimensionAndPosition();
        AnnotationBox box = dimensionAndPosition.getAnnotationBox();
        System.out.println("rotation: " + this.parameters.getFieldParameters().getRotation());
        if (this.parameters.getFieldParameters().getRotation() == null || this.parameters.getFieldParameters().getRotation() == VisualSignatureRotation.AUTOMATIC || this.parameters.getFieldParameters().getRotation() == VisualSignatureRotation.NONE || this.parameters.getFieldParameters().getRotation() == VisualSignatureRotation.ROTATE_180) {
            textBoxDimension.setTextX((float)((double)box.getWidth() * (textBox.getX() / 100.0)));
            textBoxDimension.setTextY((float)((double)box.getHeight() * (textBox.getY() / 100.0)));
            textBoxDimension.setTextWidth((float)((double)box.getWidth() * (textBox.getWidth() / 100.0)));
            textBoxDimension.setTextHeight((float)((double)box.getHeight() * (textBox.getHeight() / 100.0)));
        } else {
            textBoxDimension.setTextY((float)((double)box.getWidth() * (textBox.getY() / 100.0)));
            textBoxDimension.setTextX((float)((double)box.getHeight() * (textBox.getX() / 100.0)));
            textBoxDimension.setTextHeight((float)((double)box.getWidth() * (textBox.getHeight() / 100.0)));
            textBoxDimension.setTextWidth((float)((double)box.getHeight() * (textBox.getWidth() / 100.0)));
        }
        return textBoxDimension;
    }

    private void rotateSignature(PDPageContentStream cs, PDRectangle rectangle, SignatureFieldDimensionAndPosition dimensionAndPosition) throws IOException {
        switch (dimensionAndPosition.getGlobalRotation()) {
            case 90: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(270.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-rectangle.getHeight()), (float)0.0f));
                break;
            }
            case 180: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(180.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-rectangle.getWidth()), (float)(-rectangle.getHeight())));
                break;
            }
            case 270: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(90.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)0.0f, (float)(-rectangle.getWidth())));
                break;
            }
            case 0: 
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }

    private void drawBackgroundAndBorder(PDPageContentStream cs, Color backgroundColor, Color borderColor, PDRectangle rect) throws IOException {
        this.setAlphaChannel(cs, backgroundColor.getAlpha(), borderColor.getAlpha());
        cs.setNonStrokingColor(backgroundColor);
        cs.setStrokingColor(borderColor);
        cs.addRect(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
        cs.fillAndStroke();
    }

    private void setText(PDPageContentStream cs, SignatureFieldDimensionAndPosition box, SignatureFieldDimensionAndPosition dimensionAndPosition, DSSFont font, Color textColor, SignerTextHorizontalAlignment signerTextHorizontalAlignment, SignerTextVerticalAlignment signerTextVerticalAlignment, VisualSignatureRotation rotation, float lineSpacing) throws IOException {
        PDFont pdfFont = this.getPdfFont(font);
        PdfBoxDSSFontMetrics pdfBoxFontMetrics = new PdfBoxDSSFontMetrics(pdfFont);
        String text = dimensionAndPosition.getText();
        float lineHeight = pdfBoxFontMetrics.getHeight(text, font.getSize());
        if (lineSpacing <= 0.0f) {
            lineSpacing = 0.8f;
        }
        System.out.println("text line height: " + lineHeight);
        String[] strings = this.getLines(text, pdfBoxFontMetrics, dimensionAndPosition.getTextWidth(), font.getSize());
        cs.setNonStrokingColor(textColor);
        cs.setStrokingColor(textColor);
        this.setAlphaChannel(cs, textColor.getAlpha(), textColor.getAlpha());
        cs.beginText();
        cs.setFont(pdfFont, font.getSize());
        float leading = lineHeight * lineSpacing;
        cs.setLeading(leading);
        PDFontDescriptor fontDescriptor = pdfFont.getFontDescriptor();
        float ascent = fontDescriptor.getAscent() / 1000.0f * font.getSize();
        float descent = Math.abs(fontDescriptor.getDescent() / 1000.0f * font.getSize());
        float textY = 0.0f;
        float boxHeight = box.getBoxHeight();
        if (rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270) {
            boxHeight = box.getBoxWidth();
        }
        switch (signerTextVerticalAlignment) {
            case BOTTOM: {
                textY = boxHeight - (dimensionAndPosition.getTextY() + dimensionAndPosition.getTextHeight()) + (leading * (float)strings.length - leading + 2.0f * descent);
                break;
            }
            case MIDDLE: {
                textY = boxHeight - (dimensionAndPosition.getTextY() + dimensionAndPosition.getTextHeight() * 0.5f) + leading * (float)strings.length * 0.5f - leading + descent;
                break;
            }
            default: {
                textY = boxHeight - dimensionAndPosition.getTextY() - leading;
            }
        }
        cs.newLineAtOffset(dimensionAndPosition.getTextX(), textY);
        float previousOffset = 0.0f;
        for (String str : strings) {
            float stringWidth = pdfBoxFontMetrics.getWidth(str, font.getSize());
            float offsetX = 0.0f;
            switch (signerTextHorizontalAlignment) {
                case RIGHT: {
                    offsetX = dimensionAndPosition.getTextWidth() - stringWidth - previousOffset;
                    break;
                }
                case CENTER: {
                    offsetX = (dimensionAndPosition.getTextWidth() - stringWidth) / 2.0f - previousOffset;
                    break;
                }
            }
            previousOffset += offsetX;
            cs.newLineAtOffset(offsetX, 0.0f);
            cs.showText(str);
            cs.newLine();
        }
        cs.endText();
    }

    private String[] getLines(String text, PdfBoxDSSFontMetrics pdfBoxFontMetrics, float textWidth, float fontSize) {
        String[] lines = pdfBoxFontMetrics.getLines(text);
        ArrayList<String> wrappedLines = new ArrayList<String>();
        for (String line : lines) {
            wrappedLines.addAll(this.wrapWords(line, textWidth, fontSize, pdfBoxFontMetrics));
        }
        return wrappedLines.toArray(new String[0]);
    }

    private List<String> wrapWords(String line, float textWidth, float fontSize, PdfBoxDSSFontMetrics pdfBoxFontMetrics) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = line.split(" ");
        Object sub = "";
        for (String word : words) {
            String newLine = ((String)sub + " " + word).trim();
            if (pdfBoxFontMetrics.getWidth(newLine, fontSize) <= textWidth) {
                sub = newLine;
                continue;
            }
            List<String> wrapLines = this.wrapLine((String)sub, textWidth, fontSize, pdfBoxFontMetrics);
            sub = wrapLines.size() > 1 ? wrapLines.remove(wrapLines.size() - 1) + " " + word : word;
            lines.addAll(wrapLines);
        }
        if (!((String)sub).isBlank()) {
            lines.addAll(this.wrapLine((String)sub, textWidth, fontSize, pdfBoxFontMetrics));
        }
        return lines;
    }

    private List<String> wrapLine(String line, float textWidth, float fontSize, PdfBoxDSSFontMetrics pdfBoxFontMetrics) {
        ArrayList<String> lines = new ArrayList<String>();
        Object sub = null;
        int offset = 0;
        for (int i = 0; i < line.length(); ++i) {
            sub = line.substring(offset, i + 1);
            if (!(pdfBoxFontMetrics.getWidth((String)sub, fontSize) > textWidth)) continue;
            lines.add(line.substring(offset, i));
            offset = i;
            sub = "" + line.charAt(i);
        }
        if (sub != null && !((String)sub).isBlank()) {
            lines.add((String)sub);
        }
        return lines;
    }

    private PDColor toPDColor(Color color) {
        PDDeviceGray pdColorSpace;
        float[] components;
        if (ImageUtils.isGrayscale((Color)color)) {
            components = new float[]{(float)color.getRed() / 255.0f};
            pdColorSpace = PDDeviceGray.INSTANCE;
        } else {
            components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
            pdColorSpace = PDDeviceRGB.INSTANCE;
        }
        return new PDColor(components, (PDColorSpace)pdColorSpace);
    }

    private void setAlphaChannel(PDPageContentStream cs, float nonStrokingAlpha, float strokingAlpha) throws IOException {
        PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
        gs.setNonStrokingAlphaConstant(Float.valueOf(nonStrokingAlpha / 255.0f));
        gs.setStrokingAlphaConstant(Float.valueOf(strokingAlpha / 255.0f));
        cs.setGraphicsStateParameters(gs);
    }

    private PDRectangle getPdRectangle(SignatureFieldDimensionAndPosition dimensionAndPosition, PDPage page) {
        PDRectangle pageRect = page.getMediaBox();
        PDRectangle pdRectangle = new PDRectangle();
        pdRectangle.setLowerLeftX(dimensionAndPosition.getBoxX());
        pdRectangle.setLowerLeftY(pageRect.getHeight() - dimensionAndPosition.getBoxY() - dimensionAndPosition.getBoxHeight());
        pdRectangle.setUpperRightX(dimensionAndPosition.getBoxX() + dimensionAndPosition.getBoxWidth());
        pdRectangle.setUpperRightY(pageRect.getHeight() - dimensionAndPosition.getBoxY());
        return pdRectangle;
    }

    protected String getExpectedColorSpaceName() throws IOException {
        if (this.parameters.getImage() != null) {
            try (InputStream is = this.parameters.getImage().openStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                PDImageXObject imageXObject = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])bytes, (String)this.parameters.getImage().getName());
                PDColorSpace colorSpace = imageXObject.getColorSpace();
                String string = colorSpace.getName();
                return string;
            }
        }
        return ImageUtils.containRGBColor((SignatureImageParameters)this.parameters) ? COSName.DEVICERGB.getName() : COSName.DEVICEGRAY.getName();
    }
}

