/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.params;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.pades.params.FontStyle;
import com.anf.cryptotoken.sign.pades.params.ImageRectangle;
import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.params.TextRectangle;
import com.anf.cryptotoken.sign.pades.visible.ImageAdjustment;
import com.anf.cryptotoken.sign.pades.visible.ImageBuilder;
import com.anf.cryptotoken.sign.pades.visible.ImageMergeTool;
import com.anf.cryptotoken.sign.pades.visible.ImagePosition;
import eu.europa.esig.dss.enumerations.SignerTextPosition;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.DSSJavaFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class VisibleSignatureParams {
    private static final Logger log = Logger.getLogger(VisibleSignatureParams.class);
    private SignatureImageParameters imageParameters;
    private SignatureImageTextParameters textParameters;
    private ImageBuilder imageBuilder;
    public static final int DEFAULT_WIDTH = 150;
    public static final int DEFAULT_HEIGHT = 100;
    private boolean imageText = false;
    private ImageMergeTool imageMergeTool = new ImageMergeTool();

    public VisibleSignatureParams(int page, float x, float y) {
        this.imageParameters = new SignatureImageParameters();
        this.textParameters = new SignatureImageTextParameters();
        this.imageBuilder = new ImageBuilder(this.imageParameters, this.textParameters);
        this.setX(x);
        this.setY(y);
        this.setWidth(150);
        this.setHeight(100);
        this.imageParameters.getFieldParameters().setPage(page);
    }

    public ImageMergeTool getImageMergeTool() {
        if (this.imageMergeTool == null) {
            this.imageMergeTool = new ImageMergeTool();
        }
        return this.imageMergeTool;
    }

    public void init() {
        if (!this.imageText) {
            this.imageParameters.setTextParameters(this.textParameters);
        } else {
            this.imageParameters.setImage((DSSDocument)this.imageBuilder.buildImage());
        }
    }

    public VisibleSignatureParams(int page, float x, float y, int width, int height) {
        this(page, x, y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public VisibleSignatureParams(int page, float x, float y, int width, int height, String text) {
        this(page, x, y, width, height);
        this.setText(text);
    }

    public VisibleSignatureParams(int page, float x, float y, String text) {
        this(page, x, y);
        this.setText(text);
    }

    public VisibleSignatureParams(int page, float x, float y, int width, int height, File image) throws IOException {
        this(page, x, y, width, height);
        this.setImage(image);
    }

    public VisibleSignatureParams(int page, float x, float y, File image) throws IOException {
        this(page, x, y);
        this.setImage(image);
    }

    public VisibleSignatureParams(int page, float x, float y, int width, int height, String text, File image) throws IOException {
        this(page, x, y, width, height);
        this.setImage(image);
        this.setText(text);
    }

    public VisibleSignatureParams(int page, float x, float y, String text, File image) throws IOException {
        this(page, x, y);
        this.setImage(image);
        this.setText(text);
    }

    public void setImageText(boolean imageText) {
        this.imageText = imageText;
    }

    public boolean isImageText() {
        return this.imageText;
    }

    public void setSignatureField(String signatureField) {
        this.imageParameters.getFieldParameters().setFieldId(signatureField);
    }

    public void setX(float x) {
        this.imageParameters.getFieldParameters().setOriginX(x);
    }

    public void setY(float y) {
        this.imageParameters.getFieldParameters().setOriginY(y);
    }

    public void setWidth(int width) {
        this.imageParameters.getFieldParameters().setWidth((float)width);
    }

    public void setHeight(int height) {
        this.imageParameters.getFieldParameters().setHeight((float)height);
    }

    public void setImage(File image) throws IOException {
        this.imageBuilder.addImageBox(new ImageRectangle(new Rectangle(0.0, 0.0, 100.0, 100.0), image, ImagePosition.CENTER, ImageAdjustment.ADJUST));
    }

    public void setText(String text) {
        this.imageBuilder.setText(text);
        this.textParameters.setText(text);
    }

    public void setRotation(VisualSignatureRotation rotation) {
        this.imageParameters.getFieldParameters().setRotation(rotation);
    }

    public void setFont(String fontFamily, float size, FontStyle style) {
        DSSJavaFont dssFont = new DSSJavaFont(fontFamily, style.ordinal(), (int)size);
        dssFont.setSize(size);
        this.textParameters.setFont((DSSFont)dssFont);
    }

    public void setTextPositionRelativeToImage(SignerTextPosition position) {
        this.textParameters.setSignerTextPosition(position);
    }

    public SignatureImageParameters getImageParameters() {
        return this.imageParameters;
    }

    public SignatureImageTextParameters getTextParameters() {
        return this.textParameters;
    }

    public String getText() {
        return this.textParameters.getText();
    }

    public void setBorderColor(Color borderColor) {
        this.imageBuilder.setBorderColor(borderColor);
    }

    public void addImageBox(ImageRectangle imageBox) {
        this.imageBuilder.addImageBox(imageBox);
    }

    public void addTextBox(TextRectangle textBox) {
        this.imageBuilder.addTextBox(textBox);
    }

    public void setBackgroundColor(Color color) {
        this.textParameters.setBackgroundColor(color);
        this.imageParameters.setBackgroundColor(color);
    }

    public List<TextRectangle> getTextBoxes() {
        return this.imageBuilder.getTextBoxes();
    }

    public List<ImageRectangle> getImageBoxes() {
        return this.imageBuilder.getImageBoxes();
    }

    public Color getBorderColor() {
        return this.imageBuilder.getBorderColor();
    }

    public Color getBackgroundColor() {
        return this.imageParameters.getBackgroundColor();
    }

    public SignatureImageParameters buildImageParameters() {
        SignatureImageParameters signatureImageParameters = new SignatureImageParameters();
        signatureImageParameters.setImage((DSSDocument)this.imageBuilder.buildImage());
        return signatureImageParameters;
    }
}

