/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.params;

import com.anf.cryptotoken.sign.pades.params.FontInfo;
import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.params.TextWrap;
import com.anf.cryptotoken.sign.utils.HexToColor;
import com.anf.oauth.json.JSONFactory;
import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.DSSJavaFont;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import java.awt.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextRectangle
extends Rectangle {
    private static final Logger log = LogManager.getLogger(TextRectangle.class);
    private FontInfo font;
    private String text;
    @Deprecated
    private SignerTextHorizontalAlignment alignment = null;
    private SignerTextHorizontalAlignment horizontalAlignment = SignerTextHorizontalAlignment.LEFT;
    private SignerTextVerticalAlignment verticalAlignment = SignerTextVerticalAlignment.TOP;
    private TextWrap wrap = TextWrap.WRAP_WORD;
    private String textColor;
    private String backgroundColor;
    private float lineSpacing = 0.8f;

    public TextRectangle() {
    }

    public TextRectangle(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public TextRectangle(Rectangle other) {
        super(other);
    }

    public TextRectangle(Rectangle other, TextRectangle text) {
        super(other);
        if (text != null) {
            this.font = text.font;
            this.text = text.text;
            this.alignment = text.alignment;
            this.backgroundColor = text.backgroundColor;
            this.textColor = text.textColor;
            this.horizontalAlignment = text.horizontalAlignment;
            this.verticalAlignment = text.verticalAlignment;
            this.wrap = text.wrap;
        }
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public TextWrap getWrap() {
        if (this.wrap == null) {
            this.wrap = TextWrap.WRAP_WORD;
        }
        return this.wrap;
    }

    public void setWrap(TextWrap wrap) {
        this.wrap = wrap;
    }

    public FontInfo getFont() {
        return this.font;
    }

    public void setFont(FontInfo font) {
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SignerTextHorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(SignerTextHorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public SignerTextVerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(SignerTextVerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public SignerTextHorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(SignerTextHorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public SignatureImageTextParameters buildParams(SignatureImageTextParameters textParameters) {
        SignatureImageTextParameters params = new SignatureImageTextParameters();
        log.info("rect text: {}", (Object)this.text);
        log.info("params text: {}", (Object)textParameters.getText());
        params.setText(this.text);
        if ((this.text == null || this.text.isBlank()) && textParameters.getText() != null) {
            params.setText(textParameters.getText());
        }
        if (this.font != null && this.font.getName() != null && this.font.getStyle() != null && this.font.getSize() > 0.0f) {
            DSSJavaFont dssFont = new DSSJavaFont(this.font.getName(), this.font.getStyle().ordinal(), (int)this.font.getSize());
            dssFont.setSize(this.font.getSize());
            params.setFont((DSSFont)dssFont);
        } else {
            Font defaultFont = textParameters.getFont().getJavaFont();
            DSSJavaFont dssFont = new DSSJavaFont(defaultFont.getName(), defaultFont.getStyle(), defaultFont.getSize());
            params.setFont((DSSFont)dssFont);
            dssFont.setSize(textParameters.getFont().getSize());
        }
        if (this.horizontalAlignment == null && this.alignment != null) {
            log.info("using deprecated horizontal alignment {}", (Object)this.alignment);
            this.horizontalAlignment = this.alignment;
        }
        params.setSignerTextHorizontalAlignment(this.horizontalAlignment);
        params.setSignerTextVerticalAlignment(this.verticalAlignment);
        if (this.textColor != null) {
            params.setTextColor(HexToColor.getColor(this.textColor));
        }
        if (this.backgroundColor != null) {
            params.setBackgroundColor(HexToColor.getColor(this.backgroundColor));
        }
        return params;
    }

    public String toString() {
        return JSONFactory.buildJSON((Object)this);
    }
}

