/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.params;

import com.anf.cryptotoken.sign.pades.params.Rectangle;
import com.anf.cryptotoken.sign.pades.visible.ImageAdjustment;
import com.anf.cryptotoken.sign.pades.visible.ImagePosition;
import com.anf.cryptotoken.sign.pades.visible.SVGLoader;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class ImageRectangle
extends Rectangle {
    @JsonIgnore
    private BufferedImage buffImage;
    private byte[] image;
    private ImagePosition position = ImagePosition.TOP_LEFT;
    private ImageAdjustment adjustment = ImageAdjustment.NONE;
    private boolean svg = false;
    @JsonIgnore
    private GraphicsNode svgGraphics;

    public ImageRectangle() {
    }

    public ImageRectangle(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public ImageRectangle(Rectangle other) {
        super(other);
    }

    public ImageRectangle(Rectangle other, File image, ImagePosition position, ImageAdjustment adjustment) throws IOException {
        this(other, FileUtils.readFileToByteArray((File)image), position, adjustment);
    }

    public ImageRectangle(Rectangle other, byte[] image, ImagePosition position, ImageAdjustment adjustment) {
        super(other);
        this.image = image;
        this.position = position;
        this.adjustment = adjustment;
        if (this.position == null) {
            this.position = ImagePosition.CENTER;
        }
        if (this.adjustment == null) {
            this.adjustment = ImageAdjustment.ADJUST;
        }
    }

    public boolean isSvg() {
        return this.svg;
    }

    public void setSvg(boolean svg) {
        this.svg = svg;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public BufferedImage getBuffImage() {
        if (this.buffImage == null && this.image != null) {
            try {
                this.buffImage = ImageIO.read(new ByteArrayInputStream(this.image));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.buffImage;
    }

    public void setBuffImage(BufferedImage buffImage) {
        this.buffImage = buffImage;
    }

    public ImagePosition getPosition() {
        return this.position;
    }

    public void setPosition(ImagePosition position) {
        this.position = position;
    }

    public ImageAdjustment getAdjustment() {
        return this.adjustment;
    }

    public void setAdjustment(ImageAdjustment adjustment) {
        this.adjustment = adjustment;
    }

    public GraphicsNode getSvgGraphics() throws IOException {
        if (this.svg && this.svgGraphics == null) {
            String[] split;
            String viewBox;
            SVGDocument svgDocument = SVGLoader.instance().loadSVGDocument(this.getImage());
            SVGSVGElement rootElement = svgDocument.getRootElement();
            String width = rootElement.getAttribute("width");
            String height = rootElement.getAttribute("height");
            if ((width == null || height == null || width.isBlank() || height.isBlank()) && (viewBox = rootElement.getAttribute("viewBox")) != null && !viewBox.isBlank() && (split = viewBox.split(" ")).length == 4) {
                width = split[2];
                height = split[3];
                rootElement.setAttribute("width", width);
                rootElement.setAttribute("height", height);
            }
            if (width != null && height != null) {
                SVGLoader.instance().addTransparentPoints(svgDocument, rootElement, Double.parseDouble(width), Double.parseDouble(height));
                svgDocument = SVGLoader.instance().reloadSVGDocument(svgDocument);
            }
            this.svgGraphics = SVGLoader.instance().loadSVG(svgDocument);
        }
        return this.svgGraphics;
    }

    @JsonIgnore
    public Rectangle2D imageSize() throws IOException {
        if (this.svg) {
            this.svgGraphics = this.getSvgGraphics();
            return this.svgGraphics.getBounds();
        }
        BufferedImage bufferedImage = this.getBuffImage();
        return new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }
}

