/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.commitments;

import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.CommitmentTypeEnum;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;

public enum ANFCommitmentType implements CommitmentType
{
    ProofOfOrigin(CommitmentTypeEnum.ProofOfOrigin),
    ProofOfReceipt(CommitmentTypeEnum.ProofOfReceipt),
    ProofOfDelivery(CommitmentTypeEnum.ProofOfDelivery),
    ProofOfSender(CommitmentTypeEnum.ProofOfSender),
    ProofOfApproval(CommitmentTypeEnum.ProofOfApproval),
    ProofOfCreation(CommitmentTypeEnum.ProofOfCreation),
    accessCredentialComplete("https://www.anf.es/documentos", "1.3.6.1.4.1.18332.27.1.9"),
    intermediateAuthorizationComplete("https://www.anf.es/documentos", "1.3.6.1.4.1.18332.27.1.12"),
    readMarkComplete("https://www.anf.es/documentos", "1.3.6.1.4.1.18332.27.1.14"),
    certDigitalizationComplete("https://www.anf.es/documentos", "1.3.6.1.4.1.18332.27.1.15"),
    witnessDigitalizationComplete("https://www.anf.es/documentos", "1.3.6.1.4.1.18332.27.1.16");

    public static final String ANF_URL_DOC = "https://www.anf.es/documentos";
    private final String uri;
    private final String oid;
    private final ObjectIdentifierQualifier qualifier;
    private final String[] documentReferences;

    private ANFCommitmentType(CommitmentTypeEnum commitmentType) {
        this(commitmentType.getUri(), commitmentType.getOid(), commitmentType.getQualifier(), commitmentType.getDocumentationReferences());
    }

    private ANFCommitmentType(String uri, String oid) {
        this(uri, oid, null, new String[0]);
    }

    private ANFCommitmentType(String uri, String oid, ObjectIdentifierQualifier qualifier, String ... documentReferences) {
        this.uri = uri;
        this.oid = oid;
        this.qualifier = qualifier;
        this.documentReferences = documentReferences;
    }

    public String getUri() {
        return this.uri;
    }

    public String getOid() {
        return this.oid;
    }

    public ObjectIdentifierQualifier getQualifier() {
        return this.qualifier;
    }

    public String getDescription() {
        return this.name();
    }

    public String[] getDocumentationReferences() {
        return this.documentReferences;
    }
}

