/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.cert;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.sign.exception.CertificateValidityException;
import com.anf.cryptotoken.api.sign.exception.IssuerCertNotInTSLException;
import com.anf.cryptotoken.api.sign.exception.NoSigningCertFoundInChain;
import com.anf.cryptotoken.api.sign.exception.SelfSignedCertificateException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.json.TSLCertificateValidation;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.OCSPHandlerFactory;
import com.anf.cryptotoken.tsl.TSLController;
import com.anf.cryptotoken.utils.DatosPersonales;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;

public class SignatureCertValidation {
    private static final Logger log = Logger.getLogger(SignatureCertValidation.class);
    private X509Certificate[] chain;
    private X509Certificate certificate;
    private X509Certificate issuerCertificate;
    private boolean ocsp;
    private boolean validateTSL = false;
    private TSLController tslController;
    private CredentialsController credentialsController;
    private Date lastCheck = null;

    public SignatureCertValidation(TSLController tslController, CredentialsController credentialsController, X509Certificate[] chain, boolean validateTSL, boolean ocsp) {
        this.tslController = tslController;
        this.credentialsController = credentialsController;
        this.chain = chain;
        this.validateTSL = validateTSL;
        this.ocsp = ocsp;
    }

    public void validateSignCert() {
        Calendar cal = Calendar.getInstance();
        cal.add(12, -5);
        if (this.lastCheck == null || this.lastCheck.before(cal.getTime())) {
            DatosPersonales dp;
            String country;
            this.lastCheck = new Date();
            if (this.chain == null) {
                throw new NoSigningCertFoundInChain();
            }
            this.certificate = this.chain[CertUtils.getFinalCert((X509Certificate[])this.chain)];
            if (this.certificate == null) {
                throw new NoSigningCertFoundInChain();
            }
            try {
                this.certificate.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e1) {
                throw new CertificateValidityException((Throwable)e1);
            }
            if (CertUtils.isSelfSigned((X509Certificate)this.certificate)) {
                throw new SelfSignedCertificateException();
            }
            this.credentialsController.sendAuthURL(this.certificate);
            if (this.ocsp) {
                OCSPHandlerFactory.ocspHandler().validateOCSP(this.chain);
            }
            this.issuerCertificate = CertUtils.getIssuerCertificate((X509Certificate[])this.chain, (X509Certificate)this.certificate);
            if (this.validateTSL && this.tslController != null && this.issuerCertificate != null && !(country = (dp = new DatosPersonales(this.certificate.getSubjectX500Principal())).getC()).equals("EC") && !country.equals("PE")) {
                X509Certificate issuer = null;
                try {
                    TSLCertificateValidation validation = this.tslController.validateSignCertificateChain(this.chain);
                    issuer = validation.getTslIdCertificate();
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
                if (issuer == null) {
                    throw new IssuerCertNotInTSLException();
                }
            }
        }
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean isOcsp() {
        return true;
    }

    public X509Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public boolean isValidateTSL() {
        return this.validateTSL;
    }

    public void setValidateTSL(boolean validateTSL) {
        this.validateTSL = validateTSL;
    }

    public TSLController getTslController() {
        return this.tslController;
    }
}

