/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.cades;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.CadesSignature;
import com.anf.cryptotoken.sign.cades.params.CadesParams;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.TimestampParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.cms.CMSSignedData;

public class CadesSignatureImpl
extends AbstractSignature
implements CadesSignature {
    private static final Logger log = LogManager.getLogger(CadesSignatureImpl.class);

    public CadesSignatureImpl() {
    }

    public CadesSignatureImpl(CredentialsController credentialsController, CertificateSource trustedSource) {
        super(credentialsController, trustedSource);
    }

    public CadesSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    @Override
    public void signDetached(CadesParams params, byte[] hash, OutputStream out) {
        try {
            byte[] hashLength = params.getDigestAlg().getMessageDigest().digest(hash);
            if (hash.length != hashLength.length) {
                throw new IOException("ERR_WRONG_HASH_LENGTH:" + hash.length + " " + params.getDigestAlg().getName() + " EXPECTED:" + hashLength.length);
            }
            params.getParameters().setSignaturePackaging(SignaturePackaging.DETACHED);
            CAdESService service = this.service(params);
            DigestDocument toBeSigned = new DigestDocument(params.getDigestAlg(), Base64.getEncoder().encodeToString(hash));
            ToBeSigned dataToSign = this.getDataToSign(params, service, (DSSDocument)toBeSigned);
            this.signData(service, params, (DSSDocument)toBeSigned, dataToSign, out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    private CAdESService service(CadesParams params) {
        CAdESService service = new CAdESService((CertificateVerifier)this.commonCertificateVerifier);
        service.setTspSource(params.getTspSource());
        return service;
    }

    public void sign(CadesParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            CAdESService service = this.service(params);
            FileDocument toBeSigned = new FileDocument(src);
            ToBeSigned dataToSign = this.getDataToSign(params, service, (DSSDocument)toBeSigned);
            this.signData(service, params, (DSSDocument)toBeSigned, dataToSign, out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void extend(CadesParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            CAdESService service = this.service(params);
            DSSDocument signedDocument = service.extendDocument((DSSDocument)new FileDocument(src), params.getParameters());
            CMSSignedData signedData = ((CMSSignedDocument)signedDocument).getCMSSignedData();
            this.saveCMSSignedData(out, signedData);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public byte[] digest(CadesParams params, File src) {
        CAdESService service = this.service(params);
        FileDocument toBeSigned = new FileDocument(src);
        ToBeSigned dataToSign = this.getDataToSign(params, service, (DSSDocument)toBeSigned);
        return dataToSign.getBytes();
    }

    public void sign(CadesParams params, byte[] signature, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            CAdESService service = this.service(params);
            service.setTspSource(params.getTspSource());
            FileDocument toBeSigned = new FileDocument(src);
            DSSDocument signedDocument = service.signDocument((DSSDocument)toBeSigned, params.getParameters(), new SignatureValue(params.getParameters().getSignatureAlgorithm(), signature));
            try (InputStream in = signedDocument.openStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    private void signData(CAdESService service, CadesParams params, DSSDocument toBeSigned, ToBeSigned dataToSign, OutputStream out) throws IOException {
        CAdESSignatureParameters parameters = params.getParameters();
        CertificateParams certificateParams = params.getCertificateParams();
        SignatureToken token = certificateParams.getSignatureToken();
        DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
        this.validateSignCert(certificateParams);
        SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
        DSSDocument signedDocument = service.signDocument(toBeSigned, parameters, signatureValue);
        CMSSignedData signedData = ((CMSSignedDocument)signedDocument).getCMSSignedData();
        this.saveCMSSignedData(out, signedData);
    }

    private ToBeSigned getDataToSign(CadesParams params, CAdESService service, DSSDocument toBeSigned) {
        CAdESSignatureParameters parameters = params.getParameters();
        service.setTspSource(params.getTspSource());
        BLevelParameters bLevel = parameters.bLevel();
        bLevel.setSigningDate(new Date());
        return service.getDataToSign(toBeSigned, parameters);
    }

    public void signDouble(CadesParams params, CadesParams params2, File src, File dest) throws IOException {
        try (FileOutputStream out = new FileOutputStream(dest);){
            CAdESService service = this.service(params);
            FileDocument toBeSigned = new FileDocument(src);
            CAdESSignatureParameters parameters = params.getParameters();
            parameters.bLevel().setSigningDate(new Date());
            ToBeSigned dataToSign = service.getDataToSign((DSSDocument)toBeSigned, parameters);
            CertificateParams certificateParams = params.getCertificateParams();
            SignatureToken token = certificateParams.getSignatureToken();
            DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
            this.validateSignCert(certificateParams);
            SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
            DSSDocument signedDocument = service.signDocument((DSSDocument)toBeSigned, parameters, signatureValue);
            CAdESSignatureParameters parameters2 = params2.getParameters();
            ToBeSigned dataToSign2 = service.getDataToSign(signedDocument, parameters2);
            CertificateParams certificateParams2 = params2.getCertificateParams();
            SignatureToken token2 = certificateParams2.getSignatureToken();
            DSSPrivateKeyEntry keyInfo2 = certificateParams2.getKeyInfo();
            SignatureValue signatureValue2 = token2.sign(dataToSign2, parameters2.getDigestAlgorithm(), keyInfo2);
            DSSDocument signedDocument2 = service.signDocument(signedDocument, parameters2, signatureValue2);
            CMSSignedData signedData = ((CMSSignedDocument)signedDocument2).getCMSSignedData();
            this.saveCMSSignedData(out, signedData);
        }
    }

    protected void saveCMSSignedData(OutputStream out, CMSSignedData signedData) throws IOException {
        ASN1OutputStream derOutputStream = ASN1OutputStream.create((OutputStream)out);
        byte[] encoded = signedData.getEncoded();
        log.debug("size of cms encoded {}", (Object)encoded.length);
        ASN1Primitive asn1Primitive = DSSASN1Utils.toASN1Primitive((byte[])encoded);
        derOutputStream.writeObject(asn1Primitive);
        derOutputStream.close();
    }

    @Override
    public void timestamp(TimestampParams params, File src, File dest) {
        throw new UnsupportedOperationException("timestamp not supported on Cades");
    }
}

