/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic;

import com.anf.cryptotoken.sign.asic.AsicXadesSignatureImpl;
import com.anf.cryptotoken.sign.asic.params.AsicXadesSignatureParams;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AsicXadesDataToSignService {
    ASiCWithXAdESService service;
    List<DSSDocument> toBeSigned;
    AsicXadesSignatureImpl signImpl;

    public AsicXadesDataToSignService(AsicXadesSignatureImpl signImpl) {
        this.signImpl = signImpl;
    }

    public ToBeSigned build(AsicXadesSignatureParams params, List<File> src) {
        ASiCWithXAdESSignatureParameters parameters = this.configure(params, src);
        return this.service.getDataToSign(this.toBeSigned, parameters);
    }

    public ASiCWithXAdESSignatureParameters configure(AsicXadesSignatureParams params, List<File> src) {
        ASiCWithXAdESSignatureParameters parameters = this.configure(params);
        this.toBeSigned = new ArrayList<DSSDocument>();
        this.toBeSigned.addAll(src.stream().map(FileDocument::new).toList());
        return parameters;
    }

    public ASiCWithXAdESSignatureParameters configure(AsicXadesSignatureParams params) {
        this.service = new ASiCWithXAdESService((CertificateVerifier)this.signImpl.getCommonCertificateVerifier());
        this.service.setTspSource(params.getTspSource());
        return (ASiCWithXAdESSignatureParameters)params.getParameters();
    }
}

