/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.AsicCadesSignature;
import com.anf.cryptotoken.sign.asic.AsicCadesDataToSignService;
import com.anf.cryptotoken.sign.asic.params.AsicCadesSignatureParams;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.io.IOUtils;

public class AsicCadesSignatureImpl
extends AbstractSignature
implements AsicCadesSignature {
    public AsicCadesSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    public AsicCadesSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public AsicCadesSignatureImpl() {
    }

    public void sign(AsicCadesSignatureParams params, File src, File dest) {
        this.sign(params, List.of(src), dest);
    }

    @Override
    public void sign(AsicCadesSignatureParams params, List<File> src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            AsicCadesDataToSignService asicCadesDataToSignService = new AsicCadesDataToSignService(this);
            CertificateParams certificateParams = params.getCertificateParams();
            this.validateSignCert(certificateParams);
            ToBeSigned dataToSign = asicCadesDataToSignService.build(params, src);
            SignatureToken token = certificateParams.getSignatureToken();
            DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
            ASiCWithCAdESSignatureParameters parameters = (ASiCWithCAdESSignatureParameters)params.getParameters();
            SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
            DSSDocument signedDocument = asicCadesDataToSignService.service.signDocument(asicCadesDataToSignService.toBeSigned, parameters, signatureValue);
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public byte[] digest(AsicCadesSignatureParams params, File src) {
        return this.digest(params, List.of(src));
    }

    @Override
    public byte[] digest(AsicCadesSignatureParams params, List<File> src) {
        try {
            AsicCadesDataToSignService asicCadesDataToSignService = new AsicCadesDataToSignService(this);
            ToBeSigned dataToSign = asicCadesDataToSignService.build(params, src);
            return dataToSign.getBytes();
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void sign(AsicCadesSignatureParams params, byte[] signature, File src, File dest) {
        this.sign(params, signature, List.of(src), dest);
    }

    @Override
    public void sign(AsicCadesSignatureParams params, byte[] signature, List<File> src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            AsicCadesDataToSignService asicCadesDataToSignService = new AsicCadesDataToSignService(this);
            ASiCWithCAdESSignatureParameters parameters = asicCadesDataToSignService.configure(params, src);
            DSSDocument signedDocument = asicCadesDataToSignService.service.signDocument(asicCadesDataToSignService.toBeSigned, parameters, new SignatureValue(parameters.getSignatureAlgorithm(), signature));
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void extend(AsicCadesSignatureParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            AsicCadesDataToSignService asicCadesDataToSignService = new AsicCadesDataToSignService(this);
            ASiCWithCAdESSignatureParameters parameters = asicCadesDataToSignService.configure(params);
            DSSDocument signedDocument = asicCadesDataToSignService.service.extendDocument((DSSDocument)new FileDocument(src), parameters);
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }
}

