/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign;

import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.sign.cert.SignatureCertValidation;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.verifier.ANFCertificateSourceFactory;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import com.anf.cryptotoken.tsl.TSLController;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.UUID;

public abstract class AbstractSignature {
    private TSLController tslController = ANFControl.get().getTslControl();
    private CredentialsController credentialsController;
    private boolean validateIfCertIsQualified = true;
    private boolean validateCertOCSPStatus = true;
    protected ANFCertificateVerifier commonCertificateVerifier;

    protected AbstractSignature() {
        this(ANFControl.get().getCredentialsController(), (CertificateSource)ANFCertificateSourceFactory.getTslCertificateSource());
    }

    protected AbstractSignature(CredentialsController credentialsController, CertificateSource trustedSource) {
        this.credentialsController = credentialsController;
        this.commonCertificateVerifier = new ANFCertificateVerifier(new CertificateSource[]{trustedSource});
    }

    protected AbstractSignature(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        this();
        this.validateIfCertIsQualified = validateIfCertIsQualified;
        this.validateCertOCSPStatus = validateCertOCSPStatus;
    }

    public SignatureCertValidation validateSignCert(X509Certificate[] chain) {
        SignatureCertValidation certValidation = new SignatureCertValidation(this.tslController, this.credentialsController, chain, this.validateIfCertIsQualified, this.validateCertOCSPStatus);
        certValidation.validateSignCert();
        return certValidation;
    }

    private SignatureCertValidation validateSignCert(CertificateToken[] tokenChain) {
        X509Certificate[] chain = new X509Certificate[tokenChain.length];
        for (int i = 0; i < tokenChain.length; ++i) {
            chain[i] = tokenChain[i].getCertificate();
        }
        return this.validateSignCert(chain);
    }

    public synchronized SignatureCertValidation validateSignCert(CertificateParams params) {
        SignatureCertValidation validateSignCert = params.getSignCertValidation();
        if (validateSignCert == null) {
            validateSignCert = this.validateSignCert(params.getKeyInfo().getCertificateChain());
            params.setSignCertValidation(validateSignCert);
        } else {
            validateSignCert.validateSignCert();
        }
        X509Certificate signCert = validateSignCert.getCertificate();
        if (signCert == null) {
            throw new ANFCertificateException("ERR_NO_VALID_SIGN_CERT");
        }
        return validateSignCert;
    }

    protected File createTempSignFile(File src) {
        File tempDir = new File(Files.anf(), UUID.randomUUID().toString());
        tempDir.mkdirs();
        return new File(tempDir, src.getName());
    }

    public TSLController getTslController() {
        return this.tslController;
    }

    public CredentialsController getCredentialsController() {
        return this.credentialsController;
    }

    public void setValidateIfCertIsQualified(boolean validateIfCertIsQualified) {
        this.validateIfCertIsQualified = validateIfCertIsQualified;
    }

    public void setValidateCertOCSPStatus(boolean validateCertOCSPStatus) {
        this.validateCertOCSPStatus = validateCertOCSPStatus;
    }

    public boolean isValidateCertOCSPStatus() {
        return this.validateCertOCSPStatus;
    }

    public boolean isValidateIfCertIsQualified() {
        return this.validateIfCertIsQualified;
    }

    public void setCredentialsController(CredentialsController credentialsController) {
        this.credentialsController = credentialsController;
    }

    public ANFCertificateVerifier getCommonCertificateVerifier() {
        return this.commonCertificateVerifier;
    }
}

