/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.request.model.impl;

import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.CertProfileFactory;
import com.anf.cert.request.model.CertRequest;
import com.anf.oauth.json.JSONFactory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Base64;

public class CertRequestImpl
implements CertRequest {
    private String profile;
    @JsonIgnore
    private CertProfile certProfile;
    private String certProfileJson;

    public CertRequestImpl() {
    }

    public CertRequestImpl(String profile, String signedRequest) {
        this.profile = profile;
        this.certProfileJson = new String(Base64.getDecoder().decode(signedRequest));
        this.certProfile = CertProfileFactory.fromJson((String)profile, (String)this.certProfileJson);
    }

    public CertRequestImpl(String profile, CertProfile certProfile) {
        this.profile = profile;
        this.certProfile = certProfile;
        this.certProfileJson = JSONFactory.buildJSON((Object)this.certProfile);
    }

    public CertRequestImpl(String profile, byte[] request) {
        this.profile = profile;
        this.certProfileJson = new String(request);
        this.certProfile = CertProfileFactory.fromJson((String)profile, (String)this.certProfileJson);
    }

    @Override
    public CertProfile getCertProfile() {
        if (this.certProfile == null && this.certProfileJson != null) {
            this.certProfile = CertProfileFactory.fromJson((String)this.profile, (String)this.certProfileJson);
        }
        return this.certProfile;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }
}

