/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.registry.controller.impl;

import com.anf.cert.client.ClientConfig;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.CertProfileFactory;
import com.anf.cert.registry.client.impl.DefaultCertRegistryClient;
import com.anf.cert.registry.client.request.CertUploadRegistry;
import com.anf.cert.registry.client.response.CertRegistryResponse;
import com.anf.cert.registry.controller.CertRegistryUploadController;
import com.anf.cert.registry.exception.CertRegistryUploadException;
import com.anf.cryptotoken.api.sign.SignParams;
import com.anf.cryptotoken.device.CertificateInfo;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.oid.OIDUtils;
import com.anf.cryptotoken.sign.ARSignature;
import com.anf.cryptotoken.sign.ar.params.ARSignatureParams;
import com.anf.cryptotoken.sign.factory.SignatureFactory;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.CertificateParamsFactory;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.token.SignatureTokenFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class CertRegistryUploadControllerImpl
implements CertRegistryUploadController {
    private CertificateInfo signCert;
    private CertProfile profile;
    private ClientConfig clientConfig;

    public CertRegistryUploadControllerImpl(CertificateInfo signCert, CertProfile profile, ClientConfig clientConfig) {
        this.signCert = signCert;
        this.profile = profile;
        this.clientConfig = clientConfig;
    }

    @Override
    public CertRegistryResponse createCertRegistry(String localizator) {
        try {
            String arLoc = OIDUtils.getLocalizator((X509Certificate)this.signCert.getCert());
            String arSerial = this.signCert.getCert().getSerialNumber().toString();
            String json = CertProfileFactory.toJson((CertProfile)this.profile);
            String signedRequest = this.signRequest(json, localizator, this.signCert);
            DefaultCertRegistryClient client = new DefaultCertRegistryClient(this.clientConfig);
            CertUploadRegistry registry = new CertUploadRegistry(localizator, Base64.getEncoder().encodeToString(signedRequest.getBytes()), "ANF", arLoc, arSerial, "AR", this.profile.getTypeName());
            CertRegistryResponse resp = client.uploadCertRegistry(registry);
            if (!resp.isSuccess()) {
                throw new Exception(resp.getError());
            }
            return resp;
        }
        catch (Exception e) {
            throw new CertRegistryUploadException(e);
        }
    }

    private String signRequest(String json, String localizator, CertificateInfo certInfo) throws IOException, FileNotFoundException {
        File src = new File(Files.anf(), localizator + ".slc");
        try (FileOutputStream out = new FileOutputStream(src);){
            IOUtils.write((byte[])json.getBytes(), (OutputStream)out);
        }
        File dest = new File(Files.anf(), localizator + ".sig");
        SignatureToken signToken = SignatureTokenFactory.buildFrom((CertificateInfo)certInfo);
        CertificateParams certParams = CertificateParamsFactory.createCertificateParams((SignatureToken)signToken);
        ARSignatureParams params = new ARSignatureParams(certParams);
        ARSignature arSignature = new SignatureFactory().arSignature();
        arSignature.setValidateIfCertIsQualified(false);
        arSignature.sign((SignParams)params, src, dest);
        byte[] signedContent = null;
        try (FileInputStream in = new FileInputStream(dest);){
            signedContent = IOUtils.toByteArray((InputStream)in);
        }
        String signedRequest = new String(signedContent);
        return signedRequest;
    }
}

