/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.psd2;

import com.anf.cert.psd2.Psd2NCAInfo;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class PSD2CountryNCAService {
    private static final PSD2CountryNCAService instance = new PSD2CountryNCAService();
    private Map<String, Psd2NCAInfo> ncaMap = new TreeMap<String, Psd2NCAInfo>();

    private PSD2CountryNCAService() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.anf.cert.psd2.nca-psd2", Locale.getDefault(), ClassLoader.getSystemClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keySplit = key.split("-");
            if (keySplit.length != 2) continue;
            String country = keySplit[0];
            String idNCA = keySplit[1];
            String nameNCA = bundle.getString(key);
            this.ncaMap.put(country, new Psd2NCAInfo(country, idNCA, nameNCA));
        }
    }

    public static void main(String[] args) {
        new PSD2CountryNCAService();
    }

    public Psd2NCAInfo getNCA(String country) {
        return this.ncaMap.get(country);
    }

    public static PSD2CountryNCAService get() {
        return instance;
    }
}

