/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.generator.pkcs10;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import com.anf.pkcs10.utils.PKCS10Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public interface PKCS10Reader {
    public static PKCS10Request readPKCS10(File input) throws IOException {
        return PKCS10Reader.readPKCS10(input, null);
    }

    public static PKCS10Request readPKCS10(File input, String format) throws IOException {
        try (FileInputStream in = new FileInputStream(input);){
            PKCS10Request pKCS10Request = PKCS10Reader.readPKCS10(in, format);
            return pKCS10Request;
        }
    }

    public static PKCS10Request readPKCS10(InputStream input) throws IOException {
        return PKCS10Reader.readPKCS10(input, null);
    }

    public static PKCS10Request readPKCS10(InputStream input, String format) throws IOException {
        byte[] content = IOUtils.toByteArray((InputStream)input);
        if (format == null) {
            try (PemReader reader = new PemReader((Reader)new StringReader(new String(content)));){
                PemObject obj = reader.readPemObject();
                if (obj != null) {
                    byte[] pkcs10 = obj.getContent();
                    PKCS10Request pKCS10Request = PKCS10Reader.loadCSRFromDER(pkcs10);
                    return pKCS10Request;
                }
            }
            return PKCS10Reader.loadCSRFromDER(content);
        }
        switch (format) {
            case "DER": {
                return PKCS10RequestFactory.createNewPKCS10((byte[])content);
            }
            case "PEM": {
                return PKCS10Utils.loadPKCS10((String)new String(content));
            }
        }
        throw new IOException("ERR_INVALID_FORMAT");
    }

    public static PKCS10Request loadCSRFromDER(byte[] content) {
        try {
            return PKCS10RequestFactory.createNewPKCS10((byte[])content);
        }
        catch (Exception e) {
            return PKCS10RequestFactory.createOldPKCS10((byte[])content);
        }
    }
}

