/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.generator.pkcs10;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public interface PKCS10Generator {
    public static PKCS10Request generatePKCS10(PublicKey publicKey, X500Name subject, List<GeneralName> alternativeNames, ASN1Sequence qcStatements, ContentSigner contentSigner) throws IOException {
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(subject, publicKey);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        Extension ext = null;
        if (alternativeNames != null && !alternativeNames.isEmpty()) {
            GeneralName[] array = new GeneralName[alternativeNames.size()];
            GeneralNames generalNames = new GeneralNames(alternativeNames.toArray(array));
            ext = new Extension(Extension.subjectAlternativeName, false, generalNames.getEncoded());
            vector.add((ASN1Encodable)ext);
        }
        if (qcStatements != null) {
            ext = new Extension(Extension.qCStatements, false, qcStatements.getEncoded());
            vector.add((ASN1Encodable)ext);
        }
        DERSequence sequence = new DERSequence(vector);
        builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)sequence);
        PKCS10CertificationRequest pkcs10 = builder.build(contentSigner);
        return PKCS10RequestFactory.createNewPKCS10((byte[])pkcs10.getEncoded());
    }
}

