/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.generator.impl;

import com.anf.cert.generator.CertGenerationResult;
import com.anf.cert.generator.CertGenerator;
import com.anf.cert.generator.exception.CertGenerationException;
import com.anf.cert.generator.impl.CertDefaultResult;
import com.anf.cert.generator.pkcs10.PKCS10Generator;
import com.anf.cert.generator.pkcs10.PKCS10Writer;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.validation.client.CertValidationClient;
import com.anf.cert.validation.client.request.CertValidationRequest;
import com.anf.cert.validation.client.response.CertValidationMessage;
import com.anf.cert.validation.client.response.CertValidationResponse;
import com.anf.pkcs10.PKCS10Request;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class DefaultCertGenerator
implements CertGenerator {
    private int defaultDaysExpiration = 90;
    private CertProfile profile;
    private File csr;
    private File keyStore;
    private String format;
    private String cryptoProvider;
    private String signatureAlgorithm = "SHA256withRSA";
    private String keyAlgorithm = "RSA";
    private CertValidationClient validationClient;
    private String pkcs10Format = "PEM";

    public DefaultCertGenerator(CertProfile profile, File csr, File keyStore, String format, String cryptoProvider, CertValidationClient client) {
        this.profile = profile;
        this.csr = csr;
        this.keyStore = keyStore;
        this.format = format;
        this.cryptoProvider = cryptoProvider;
        this.validationClient = client;
    }

    @Override
    public CertGenerationResult createCert(char[] keyStorePassword) throws CertGenerationException {
        CertDefaultResult result = null;
        try {
            KeyPairGenerator keysGen = KeyPairGenerator.getInstance(this.keyAlgorithm, this.cryptoProvider);
            keysGen.initialize(this.profile.getKeyLength());
            KeyPair keyPair = keysGen.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            X500Name subject = this.profile.createSubject();
            ASN1Sequence qcStatements = null;
            JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm);
            ContentSigner contentSigner = contentSignerBuilder.build(privateKey);
            PKCS10Request pkcs10 = PKCS10Generator.generatePKCS10(publicKey, subject, this.profile.getSubjectAltNames(), qcStatements, contentSigner);
            X509Certificate selfSignedCert = this.generateSelfSignedCertificate(publicKey, subject, contentSigner);
            KeyStore store = this.generateKeyStore(keyStorePassword, privateKey, selfSignedCert);
            this.exportResult(keyStorePassword, pkcs10, store);
            String policy = this.profile.getPolicyOid();
            result = new CertDefaultResult(pkcs10, selfSignedCert, store, policy);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | OperatorCreationException e) {
            throw new CertGenerationException(e);
        }
        return result;
    }

    private List<CertValidationMessage> validateCertificate(X509Certificate selfSignedCert) throws CertificateEncodingException {
        CertValidationRequest request = new CertValidationRequest(selfSignedCert, true, false);
        CertValidationResponse response = this.validationClient.validateCertificate(request);
        if (response == null) {
            throw new CertGenerationException("ERR_NULL_RESPONSE_FROM_SERVER");
        }
        if (!response.isSuccess()) {
            throw new CertGenerationException(response.getError());
        }
        List<CertValidationMessage> messages = response.getMessages();
        for (CertValidationMessage msg : messages) {
            if (msg.getLevel() == null || !msg.getLevel().equals("E") && !msg.getLevel().equals("F")) continue;
            throw new CertGenerationException("ERR_FORMAT_ERROR:" + msg.getInfo());
        }
        return messages;
    }

    protected void exportResult(char[] keyStorePassword, PKCS10Request pkcs10, KeyStore store) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        try (FileOutputStream out = new FileOutputStream(this.keyStore);){
            store.store(out, keyStorePassword);
        }
        PKCS10Writer.writePKCS10(pkcs10, this.csr, this.pkcs10Format);
    }

    protected KeyStore generateKeyStore(char[] keyStorePassword, PrivateKey privateKey, X509Certificate selfSignedCert) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(this.format, this.cryptoProvider);
        store.load(null, keyStorePassword);
        store.setKeyEntry(UUID.randomUUID().toString(), privateKey, keyStorePassword, new X509Certificate[]{selfSignedCert});
        return store;
    }

    protected X509Certificate generateSelfSignedCertificate(PublicKey publicKey, X500Name subject, ContentSigner contentSigner) throws CertificateException {
        BigInteger serial = new BigInteger(64, new Random(System.nanoTime()));
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(6, this.defaultDaysExpiration);
        Date notAfter = cal.getTime();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(subject, serial, notBefore, notAfter, subject, publicKey);
        X509Certificate selfSignedCert = new JcaX509CertificateConverter().setProvider(Security.getProvider("BC")).getCertificate(certGen.build(contentSigner));
        return selfSignedCert;
    }

    public void setPkcs10Format(String pkcs10Format) {
        this.pkcs10Format = pkcs10Format;
    }

    public String getPkcs10Format() {
        return this.pkcs10Format;
    }
}

