/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.activate.impl;

import com.anf.cert.activate.CertActivationResult;
import com.anf.cert.activate.CertRequestActivation;
import com.anf.cert.activate.exception.ActivationException;
import com.anf.cert.activate.impl.CertActivationResultImpl;
import com.anf.cert.client.ClientConfig;
import com.anf.cert.generator.CertGenerationResult;
import com.anf.cert.generator.CertGenerator;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.CertProfileFactory;
import com.anf.cert.profile.ContactInfo;
import com.anf.cert.request.download.client.impl.DefaultCertDownloadRequestClient;
import com.anf.cert.request.download.client.response.CertDownloadRequestResponse;
import com.anf.cert.request.upload.client.CertUploadClient;
import com.anf.cert.request.upload.client.impl.DefaultCertUploadClient;
import com.anf.cert.request.upload.client.response.CertUploadResponse;
import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.validation.client.CertValidationClient;
import com.anf.cert.validation.client.impl.CertValidationClientImpl;
import com.anf.pkcs10.PKCS10Request;
import java.io.File;
import java.util.function.Supplier;

public abstract class CertAbstractRequestActivation
implements CertRequestActivation {
    private ClientConfig clientConfig;
    protected File csr;
    protected Supplier<char[]> pinRequest;
    protected CertUploadClient uploadClient;

    public CertAbstractRequestActivation(ClientConfig clientConfig, File csr, Supplier<char[]> pinRequest) {
        this.clientConfig = clientConfig;
        this.csr = csr;
        this.pinRequest = pinRequest;
        AgregarProveedor.agregarBouncyCastleProvider();
        this.uploadClient = new DefaultCertUploadClient(clientConfig);
    }

    @Override
    public CertActivationResult activateCertRequest(String localizator, String password) {
        try {
            DefaultCertDownloadRequestClient client = new DefaultCertDownloadRequestClient(this.clientConfig);
            CertDownloadRequestResponse response = client.downloadCertRequest(localizator, password);
            if (!response.isSuccess()) {
                throw new ActivationException("ERR_DOWNLOAD_REQUEST", new Exception(response.getError()));
            }
            CertProfile profile = CertProfileFactory.fromJson((String)response.getProfile(), (String)response.getSignedRequest());
            return this.activateCertRequest(localizator, profile);
        }
        catch (ActivationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ActivationException("ERR_ACTIVATION", e);
        }
    }

    @Override
    public CertActivationResult activateCertRequest(String localizator, CertProfile profile) {
        return this.activateCertRequest(localizator, profile, null);
    }

    @Override
    public CertActivationResult activateCertRequest(String localizator, CertProfile profile, String statusUrl) {
        CertGenerationResult result = this.generateCertRequest(profile);
        CertUploadResponse uploadResponse = this.uploadClient.uploadSSL(localizator, profile, result, statusUrl);
        if (!uploadResponse.isSuccess()) {
            throw new ActivationException("ERR_UPLOAD_SSL", new Exception(uploadResponse.getError()));
        }
        return new CertActivationResultImpl(profile, result, uploadResponse);
    }

    @Override
    public CertUploadResponse uploadCSRRequest(String profile, PKCS10Request csr, ContactInfo contactInfo) {
        CertUploadResponse uploadResponse = this.uploadClient.uploadCSR(profile, contactInfo, csr);
        return uploadResponse;
    }

    @Override
    public CertGenerationResult generateCertRequest(CertProfile profile) {
        CertValidationClientImpl validationClient = new CertValidationClientImpl(this.clientConfig);
        CertGenerator generator = this.createCertGenerator(profile, validationClient);
        char[] keyStorePassword = this.pinRequest != null ? this.pinRequest.get() : null;
        CertGenerationResult result = generator.createCert(keyStorePassword);
        return result;
    }

    protected abstract CertGenerator createCertGenerator(CertProfile var1, CertValidationClient var2);
}

